/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.init.ModBlocks;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockRayTrace {
    private static final Predicate<BlockState> IGNORES = input -> input != null && input.is(ModBlocks.BULLET_IGNORE_BLOCKS);

    public static BlockHitResult rayTraceBlocks(Level level, ClipContext context) {
        return BlockRayTrace.performRayTrace(context, (rayTraceContext, blockPos) -> {
            ResourceLocation blockId;
            BlockState blockState = level.getBlockState(blockPos);
            List ids = (List)AmmoConfig.PASS_THROUGH_BLOCKS.get();
            if (ids.contains((blockId = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())).toString())) {
                return null;
            }
            if (IGNORES.test(blockState)) {
                return null;
            }
            return BlockRayTrace.getBlockHitResult(level, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            Vec3 vec3 = rayTraceContext.getFrom().subtract(rayTraceContext.getTo());
            return BlockHitResult.miss((Vec3)rayTraceContext.getTo(), (Direction)Direction.getNearest((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockPos)BlockPos.containing((Position)rayTraceContext.getTo()));
        });
    }

    @Nullable
    private static BlockHitResult getBlockHitResult(Level level, ClipContext rayTraceContext, BlockPos blockPos, BlockState blockState) {
        FluidState fluidState = level.getFluidState(blockPos);
        Vec3 startVec = rayTraceContext.getFrom();
        Vec3 endVec = rayTraceContext.getTo();
        VoxelShape blockShape = rayTraceContext.getBlockShape(blockState, (BlockGetter)level, blockPos);
        BlockHitResult blockResult = level.clipWithInteractionOverride(startVec, endVec, blockPos, blockShape, blockState);
        VoxelShape fluidShape = rayTraceContext.getFluidShape(fluidState, (BlockGetter)level, blockPos);
        BlockHitResult fluidResult = fluidShape.clip(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(blockResult.getLocation());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(fluidResult.getLocation());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> missFactory) {
        Vec3 endVec;
        Vec3 startVec = context.getFrom();
        if (!startVec.equals((Object)(endVec = context.getTo()))) {
            int blockZ;
            int blockY;
            double startX = Mth.lerp((double)-1.0E-7, (double)endVec.x, (double)startVec.x);
            double startY = Mth.lerp((double)-1.0E-7, (double)endVec.y, (double)startVec.y);
            double startZ = Mth.lerp((double)-1.0E-7, (double)endVec.z, (double)startVec.z);
            double endX = Mth.lerp((double)-1.0E-7, (double)startVec.x, (double)endVec.x);
            double endY = Mth.lerp((double)-1.0E-7, (double)startVec.y, (double)endVec.y);
            double endZ = Mth.lerp((double)-1.0E-7, (double)startVec.z, (double)endVec.z);
            int blockX = Mth.floor((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.floor((double)endY), blockZ = Mth.floor((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.sign((double)deltaX);
            int signY = Mth.sign((double)deltaY);
            int signZ = Mth.sign((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.frac((double)endX) : Mth.frac((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.frac((double)endY) : Mth.frac((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.frac((double)endZ) : Mth.frac((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.set(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return missFactory.apply(context);
    }
}

