/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.resource.CommonAssetsManager;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public final class AllowAttachmentTagMatcher {
    private static final String TAG_PREFIX = "#";
    private static final Cache CACHE = new Cache();

    public static boolean match(ResourceLocation gunId, ResourceLocation attachmentId) {
        Pair key = Pair.of((Object)gunId, (Object)attachmentId);
        return CACHE.allowAttachmentCache().computeIfAbsent((Pair<ResourceLocation, ResourceLocation>)key, AllowAttachmentTagMatcher::match0);
    }

    public static boolean match0(Pair<ResourceLocation, ResourceLocation> record) {
        ResourceLocation gunId = (ResourceLocation)record.getLeft();
        ResourceLocation attachmentId = (ResourceLocation)record.getRight();
        Set<String> allowAttachmentTags = CommonAssetsManager.get().getAllowAttachmentTags(gunId);
        if (allowAttachmentTags == null || allowAttachmentTags.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(allowAttachmentTags, attachmentId, searchSignal);
        return searchSignal.get();
    }

    public static boolean matchTag(ResourceLocation tag, ResourceLocation attachmentId) {
        Pair key = Pair.of((Object)tag, (Object)attachmentId);
        return CACHE.tagMatchCache().computeIfAbsent((Pair<ResourceLocation, ResourceLocation>)key, AllowAttachmentTagMatcher::matchTag0);
    }

    public static boolean matchTag0(Pair<ResourceLocation, ResourceLocation> record) {
        ResourceLocation tag = (ResourceLocation)record.getLeft();
        ResourceLocation attachmentId = (ResourceLocation)record.getRight();
        Set<String> tagContent = CommonAssetsManager.get().getAttachmentTags(tag);
        if (tagContent == null || tagContent.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(tagContent, attachmentId, searchSignal);
        return searchSignal.get();
    }

    private static void treeSearch(Set<String> tags, ResourceLocation attachmentId, AtomicBoolean searchSignal) {
        for (String tag : tags) {
            if (tag.startsWith(TAG_PREFIX)) {
                ResourceLocation tagId = ResourceLocation.parse((String)tag.substring(TAG_PREFIX.length()));
                Set<String> attachmentTags = CommonAssetsManager.get().getAttachmentTags(tagId);
                if (attachmentTags == null || attachmentTags.isEmpty()) continue;
                AllowAttachmentTagMatcher.treeSearch(attachmentTags, attachmentId, searchSignal);
                continue;
            }
            ResourceLocation matchAttachmentId = ResourceLocation.parse((String)tag);
            if (!attachmentId.equals((Object)matchAttachmentId)) continue;
            searchSignal.set(true);
            return;
        }
    }

    public static void resetCache() {
        CACHE.allowAttachmentCache().clear();
        CACHE.tagMatchCache().clear();
    }

    public record Cache(Map<Pair<ResourceLocation, ResourceLocation>, Boolean> allowAttachmentCache, Map<Pair<ResourceLocation, ResourceLocation>, Boolean> tagMatchCache) {
        public Cache() {
            this(new ConcurrentHashMap<Pair<ResourceLocation, ResourceLocation>, Boolean>(), new ConcurrentHashMap<Pair<ResourceLocation, ResourceLocation>, Boolean>());
        }
    }
}

