/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.pojo.data.gun;

import com.google.common.collect.Maps;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.util.HitboxHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public enum InaccuracyType {
    STAND,
    MOVE,
    SNEAK,
    LIE,
    AIM;


    public static InaccuracyType getInaccuracyType(LivingEntity livingEntity) {
        float aimingProgress = IGunOperator.fromLivingEntity(livingEntity).getSynAimingProgress();
        if (aimingProgress == 1.0f) {
            return AIM;
        }
        if (!livingEntity.isSwimming() && livingEntity.getPose() == Pose.SWIMMING) {
            return LIE;
        }
        if (livingEntity.getPose() == Pose.CROUCHING) {
            return SNEAK;
        }
        if (InaccuracyType.isMove(livingEntity)) {
            return MOVE;
        }
        return STAND;
    }

    public static Map<InaccuracyType, Float> getDefaultInaccuracy() {
        HashMap inaccuracy = Maps.newHashMap();
        inaccuracy.put(STAND, Float.valueOf(5.0f));
        inaccuracy.put(MOVE, Float.valueOf(5.75f));
        inaccuracy.put(SNEAK, Float.valueOf(3.5f));
        inaccuracy.put(LIE, Float.valueOf(2.5f));
        inaccuracy.put(AIM, Float.valueOf(0.15f));
        return inaccuracy;
    }

    private static boolean isMove(LivingEntity livingEntity) {
        double distance = Math.abs(livingEntity.walkDist - livingEntity.walkDistO);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            distance = HitboxHelper.getPlayerVelocity(player).length();
        }
        return distance > (double)0.05f;
    }

    public boolean isAim() {
        return this == AIM;
    }
}

