/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.ICommonResourceProvider;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;

public enum CommonNetworkCache implements ICommonResourceProvider
{
    INSTANCE;

    public Map<ResourceLocation, GunData> gunData = new HashMap<ResourceLocation, GunData>();
    public Map<ResourceLocation, AttachmentData> attachmentData = new HashMap<ResourceLocation, AttachmentData>();
    public Map<ResourceLocation, RecipeFilter> recipeFilter = new HashMap<ResourceLocation, RecipeFilter>();
    public Map<ResourceLocation, BlockData> blockData = new HashMap<ResourceLocation, BlockData>();
    public Map<ResourceLocation, CommonGunIndex> gunIndex = new HashMap<ResourceLocation, CommonGunIndex>();
    public Map<ResourceLocation, CommonAmmoIndex> ammoIndex = new HashMap<ResourceLocation, CommonAmmoIndex>();
    public Map<ResourceLocation, CommonAttachmentIndex> attachmentIndex = new HashMap<ResourceLocation, CommonAttachmentIndex>();
    public Map<ResourceLocation, CommonBlockIndex> blockIndex = new HashMap<ResourceLocation, CommonBlockIndex>();
    public Map<ResourceLocation, Set<String>> attachmentTags = new HashMap<ResourceLocation, Set<String>>();
    public Map<ResourceLocation, Set<String>> allowAttachmentTags = new HashMap<ResourceLocation, Set<String>>();

    @Override
    @Nullable
    public GunData getGunData(ResourceLocation id) {
        return this.gunData.get(id);
    }

    @Override
    @Nullable
    public AttachmentData getAttachmentData(ResourceLocation attachmentId) {
        return this.attachmentData.get(attachmentId);
    }

    @Override
    @Nullable
    public BlockData getBlockData(ResourceLocation id) {
        return this.blockData.get(id);
    }

    @Override
    @Nullable
    public RecipeFilter getRecipeFilter(ResourceLocation id) {
        return this.recipeFilter.get(id);
    }

    @Override
    @Nullable
    public CommonGunIndex getGunIndex(ResourceLocation id) {
        return this.gunIndex.get(id);
    }

    @Override
    @Nullable
    public CommonAmmoIndex getAmmoIndex(ResourceLocation ammoId) {
        return this.ammoIndex.get(ammoId);
    }

    @Override
    @Nullable
    public CommonAttachmentIndex getAttachmentIndex(ResourceLocation attachmentId) {
        return this.attachmentIndex.get(attachmentId);
    }

    @Override
    @Nullable
    public CommonBlockIndex getBlockIndex(ResourceLocation blockId) {
        return this.blockIndex.get(blockId);
    }

    @Override
    @Nullable
    public LuaTable getScript(ResourceLocation scriptId) {
        return null;
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonGunIndex>> getAllGuns() {
        return this.gunIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonAmmoIndex>> getAllAmmos() {
        return this.ammoIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonAttachmentIndex>> getAllAttachments() {
        return this.attachmentIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonBlockIndex>> getAllBlocks() {
        return this.blockIndex.entrySet();
    }

    @Override
    public Set<String> getAttachmentTags(ResourceLocation registryName) {
        return this.attachmentTags.get(registryName);
    }

    @Override
    public Set<String> getAllowAttachmentTags(ResourceLocation registryName) {
        return this.allowAttachmentTags.get(registryName);
    }

    public void fromNetwork(Map<DataType, Map<ResourceLocation, String>> cache) {
        this.gunData.clear();
        this.attachmentData.clear();
        this.gunIndex.clear();
        this.ammoIndex.clear();
        this.attachmentIndex.clear();
        this.blockIndex.clear();
        this.recipeFilter.clear();
        this.blockData.clear();
        this.attachmentTags.clear();
        this.allowAttachmentTags.clear();
        HashMap<DataType, Map<ResourceLocation, String>> delayed = new HashMap<DataType, Map<ResourceLocation, String>>();
        block3: for (Map.Entry<DataType, Map<ResourceLocation, String>> entry : cache.entrySet()) {
            switch (entry.getKey()) {
                case GUN_INDEX: 
                case AMMO_INDEX: 
                case ATTACHMENT_INDEX: 
                case BLOCK_INDEX: {
                    delayed.put(entry.getKey(), entry.getValue());
                    continue block3;
                }
            }
            this.fromNetwork(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<DataType, Map<Object, String>> entry : delayed.entrySet()) {
            this.fromNetwork(entry.getKey(), entry.getValue());
        }
        AllowAttachmentTagMatcher.resetCache();
    }

    private <T> T parse(String json, Class<T> dataClass) {
        return (T)CommonAssetsManager.GSON.fromJson(json, dataClass);
    }

    private AttachmentData parseAttachmentData(String json) {
        AttachmentData data = (AttachmentData)CommonAssetsManager.GSON.fromJson(json, AttachmentData.class);
        JsonElement element = (JsonElement)CommonAssetsManager.GSON.fromJson(json, JsonElement.class);
        if (data != null) {
            AttachmentPropertyManager.getModifiers().forEach((key, value) -> {
                if (!element.isJsonObject()) {
                    return;
                }
                JsonObject jsonObject = element.getAsJsonObject();
                if (jsonObject.has(key)) {
                    JsonProperty property = value.readJson(json);
                    property.initComponents();
                    data.addModifier((String)key, property);
                } else if (jsonObject.has(value.getOptionalFields())) {
                    JsonProperty property = value.readJson(json);
                    property.initComponents();
                    data.addModifier((String)key, property);
                }
            });
        }
        return data;
    }

    private void resolveAttachmentTags(Map<ResourceLocation, String> data) {
        for (Map.Entry<ResourceLocation, String> entry : data.entrySet()) {
            List tags = (List)CommonAssetsManager.GSON.fromJson(entry.getValue(), (TypeToken)new TypeToken<List<String>>(this){});
            if (entry.getKey().getPath().startsWith("allow_attachments/") && entry.getKey().getPath().length() > 18) {
                ResourceLocation gunId = entry.getKey().withPath(entry.getKey().getPath().substring(18));
                this.allowAttachmentTags.computeIfAbsent(gunId, v -> new HashSet()).addAll(tags);
                continue;
            }
            this.attachmentTags.computeIfAbsent(entry.getKey(), v -> new HashSet()).addAll(tags);
        }
    }

    private void fromNetwork(DataType type, Map<ResourceLocation, String> data) {
        for (Map.Entry<ResourceLocation, String> entry : data.entrySet()) {
            try {
                switch (type) {
                    case GUN_DATA: {
                        this.gunData.put(entry.getKey(), this.parse(entry.getValue(), GunData.class));
                        break;
                    }
                    case GUN_INDEX: {
                        this.gunIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonGunIndex.class));
                        break;
                    }
                    case AMMO_INDEX: {
                        this.ammoIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonAmmoIndex.class));
                        break;
                    }
                    case ATTACHMENT_DATA: {
                        this.attachmentData.put(entry.getKey(), this.parseAttachmentData(entry.getValue()));
                        break;
                    }
                    case ATTACHMENT_INDEX: {
                        this.attachmentIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonAttachmentIndex.class));
                        break;
                    }
                    case ATTACHMENT_TAGS: {
                        this.resolveAttachmentTags(data);
                        break;
                    }
                    case BLOCK_INDEX: {
                        this.blockIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonBlockIndex.class));
                        break;
                    }
                    case RECIPE_FILTER: {
                        this.recipeFilter.put(entry.getKey(), this.parse(entry.getValue(), RecipeFilter.class));
                        break;
                    }
                    case BLOCK_DATA: {
                        this.blockData.put(entry.getKey(), this.parse(entry.getValue(), BlockData.class));
                    }
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                GunMod.LOGGER.warn("Failed to parse data from network for {} with id {}", (Object)type, (Object)entry.getKey(), (Object)exception);
            }
        }
    }
}

