/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class InaccuracyModifier
implements IAttachmentModifier<Map<InaccuracyType, Modifier>, Map<InaccuracyType, Float>> {
    public static final String ID = GunProperties.INACCURACY.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getOptionalFields() {
        return "inaccuracy_addend";
    }

    @Override
    public JsonProperty<Map<InaccuracyType, Modifier>> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        Modifier inaccuracy = data.getInaccuracy();
        Modifier aimInaccuracy = data.getAimInaccuracy();
        Modifier sneakInaccuracy = data.getSneakInaccuracy();
        Modifier lieInaccuracy = data.getLieInaccuracy();
        if (inaccuracy == null) {
            float inaccuracyAddendTime = data.getInaccuracyAddendTime();
            inaccuracy = new Modifier();
            inaccuracy.setAddend(inaccuracyAddendTime);
        }
        HashMap jsonProperties = Maps.newHashMap();
        block5: for (InaccuracyType type : InaccuracyType.values()) {
            switch (type) {
                case AIM: {
                    if (aimInaccuracy == null) continue block5;
                    jsonProperties.put(type, aimInaccuracy);
                    continue block5;
                }
                case SNEAK: {
                    if (sneakInaccuracy == null) continue block5;
                    jsonProperties.put(type, sneakInaccuracy);
                    continue block5;
                }
                case LIE: {
                    if (lieInaccuracy == null) continue block5;
                    jsonProperties.put(type, lieInaccuracy);
                    continue block5;
                }
                default: {
                    jsonProperties.put(type, inaccuracy);
                }
            }
        }
        return new InaccuracyJsonProperty(jsonProperties);
    }

    @Override
    public CacheValue<Map<InaccuracyType, Float>> initCache(ItemStack gunItem, GunData gunData) {
        HashMap tmp = Maps.newHashMap();
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        gunData.getInaccuracy().forEach((type, value) -> {
            float inaccuracyAddend = 0.0f;
            GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
            if (fireModeAdjustData != null) {
                inaccuracyAddend = type == InaccuracyType.AIM ? fireModeAdjustData.getAimInaccuracy() : fireModeAdjustData.getOtherInaccuracy();
            }
            float inaccuracy = gunData.getInaccuracy((InaccuracyType)((Object)type), inaccuracyAddend);
            tmp.put(type, Float.valueOf(inaccuracy));
        });
        return new CacheValue<Map<InaccuracyType, Float>>(tmp);
    }

    @Override
    public void eval(List<Map<InaccuracyType, Modifier>> modifiedValues, CacheValue<Map<InaccuracyType, Float>> cache) {
        HashMap result = Maps.newHashMap();
        HashMap tmpModified = Maps.newHashMap();
        for (InaccuracyType type2 : InaccuracyType.values()) {
            ArrayList tmp = Lists.newArrayList();
            for (Map<InaccuracyType, Modifier> value2 : modifiedValues) {
                if (value2.get((Object)type2) == null) continue;
                tmp.add(value2.get((Object)type2));
            }
            tmpModified.put(type2, tmp);
        }
        cache.getValue().forEach((type, value) -> {
            double eval = AttachmentPropertyManager.eval((List)tmpModified.get(type), (double)((Float)((Map)cache.getValue()).get(type)).floatValue());
            result.put(type, Float.valueOf((float)eval));
        });
        cache.setValue(result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        return List.of(this.buildNormal(gunData, cacheProperty, fireModeAdjustData, InaccuracyType.STAND, "gui.tacz.gun_refit.property_diagrams.hipfire_inaccuracy", 10.0), this.buildNormal(gunData, cacheProperty, fireModeAdjustData, InaccuracyType.SNEAK, "gui.tacz.gun_refit.property_diagrams.sneak_inaccuracy", 5.0), this.buildNormal(gunData, cacheProperty, fireModeAdjustData, InaccuracyType.LIE, "gui.tacz.gun_refit.property_diagrams.lie_inaccuracy", 5.0), this.buildAim(gunData, cacheProperty, fireModeAdjustData));
    }

    @NotNull
    private IAttachmentModifier.DiagramsData buildNormal(GunData gunData, AttachmentCacheProperty cacheProperty, GunFireModeAdjustData fireModeAdjustData, InaccuracyType type, String titleKey, double referenceValue) {
        float inaccuracy = gunData.getInaccuracy(type);
        if (fireModeAdjustData != null) {
            inaccuracy += fireModeAdjustData.getOtherInaccuracy();
        }
        float modifiedValue = ((Float)((Map)cacheProperty.getCache(ID)).get((Object)type)).floatValue();
        float inaccuracyModifier = modifiedValue - inaccuracy;
        double standInaccuracyPercent = Math.min((double)inaccuracy / referenceValue, 1.0);
        double inaccuracyModifierPercent = Math.min((double)inaccuracyModifier / referenceValue, 1.0);
        String positivelyString = String.format("%.2f \u00a7c(+%.2f)", Float.valueOf(modifiedValue), Float.valueOf(inaccuracyModifier));
        String negativelyString = String.format("%.2f \u00a7a(%.2f)", Float.valueOf(modifiedValue), Float.valueOf(inaccuracyModifier));
        String defaultString = String.format("%.2f", Float.valueOf(modifiedValue));
        boolean positivelyBetter = false;
        return new IAttachmentModifier.DiagramsData(standInaccuracyPercent, inaccuracyModifierPercent, Float.valueOf(inaccuracyModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
    }

    @NotNull
    private IAttachmentModifier.DiagramsData buildAim(GunData gunData, AttachmentCacheProperty cacheProperty, GunFireModeAdjustData fireModeAdjustData) {
        float aimInaccuracy = gunData.getInaccuracy(InaccuracyType.AIM);
        if (fireModeAdjustData != null) {
            aimInaccuracy += fireModeAdjustData.getAimInaccuracy();
        }
        aimInaccuracy = 1.0f - aimInaccuracy;
        float modifiedValue = 1.0f - ((Float)((Map)cacheProperty.getCache(ID)).get((Object)InaccuracyType.AIM)).floatValue();
        aimInaccuracy = Mth.clamp((float)aimInaccuracy, (float)0.0f, (float)1.0f);
        modifiedValue = Mth.clamp((float)modifiedValue, (float)0.0f, (float)1.0f);
        float inaccuracyModifier = modifiedValue - aimInaccuracy;
        double aimInaccuracyPercent = Mth.clamp((float)aimInaccuracy, (float)0.0f, (float)1.0f);
        double inaccuracyModifierPercent = Mth.clamp((float)inaccuracyModifier, (float)0.0f, (float)1.0f);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.aim_inaccuracy";
        String positivelyString = String.format("%.1f%% \u00a7a(+%.1f%%)", Float.valueOf(modifiedValue * 100.0f), Float.valueOf(inaccuracyModifier * 100.0f));
        String negativelyString = String.format("%.1f%% \u00a7c(%.1f%%)", Float.valueOf(modifiedValue * 100.0f), Float.valueOf(inaccuracyModifier * 100.0f));
        String defaultString = String.format("%.1f%%", Float.valueOf(modifiedValue * 100.0f));
        boolean positivelyBetter = true;
        return new IAttachmentModifier.DiagramsData(aimInaccuracyPercent, inaccuracyModifierPercent, Float.valueOf(inaccuracyModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 3;
    }

    public static class Data {
        @Nullable
        @SerializedName(value="inaccuracy")
        private Modifier inaccuracy;
        @Nullable
        @SerializedName(value="aim_inaccuracy")
        private Modifier aimInaccuracy;
        @Nullable
        @SerializedName(value="sneak_inaccuracy")
        private Modifier sneakInaccuracy;
        @Nullable
        @SerializedName(value="lie_inaccuracy")
        private Modifier lieInaccuracy;
        @SerializedName(value="inaccuracy_addend")
        @Deprecated
        private float adsAddendTime = 0.0f;

        @Nullable
        public Modifier getInaccuracy() {
            return this.inaccuracy;
        }

        @Nullable
        public Modifier getAimInaccuracy() {
            return this.aimInaccuracy;
        }

        @Nullable
        public Modifier getSneakInaccuracy() {
            return this.sneakInaccuracy;
        }

        @Nullable
        public Modifier getLieInaccuracy() {
            return this.lieInaccuracy;
        }

        @Deprecated
        public float getInaccuracyAddendTime() {
            return this.adsAddendTime;
        }
    }

    public static class InaccuracyJsonProperty
    extends JsonProperty<Map<InaccuracyType, Modifier>> {
        public InaccuracyJsonProperty(Map<InaccuracyType, Modifier> value) {
            super(value);
        }

        @Override
        public void initComponents() {
            this.createEntry(InaccuracyType.STAND, "tooltip.tacz.attachment.inaccuracy.decrease", "tooltip.tacz.attachment.inaccuracy.increase");
            this.createEntry(InaccuracyType.AIM, "tooltip.tacz.attachment.aim_inaccuracy.decrease", "tooltip.tacz.attachment.aim_inaccuracy.increase");
            this.createEntry(InaccuracyType.SNEAK, "tooltip.tacz.attachment.sneak_inaccuracy.decrease", "tooltip.tacz.attachment.sneak_inaccuracy.increase");
            this.createEntry(InaccuracyType.LIE, "tooltip.tacz.attachment.lie_inaccuracy.decrease", "tooltip.tacz.attachment.lie_inaccuracy.increase");
        }

        private void createEntry(InaccuracyType type, String decreaseKey, String increaseKey) {
            Map value = (Map)this.getValue();
            float inaccuracyAddend = 0.0f;
            if (value != null && value.containsKey((Object)type)) {
                double eval = AttachmentPropertyManager.eval((Modifier)value.get((Object)type), 5.0);
                inaccuracyAddend = (float)(eval - 5.0);
            }
            if (inaccuracyAddend > 0.0f) {
                this.components.add(Component.translatable((String)decreaseKey).withStyle(ChatFormatting.RED));
            } else if (inaccuracyAddend < 0.0f) {
                this.components.add(Component.translatable((String)increaseKey).withStyle(ChatFormatting.GREEN));
            }
        }
    }
}

