/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class IgniteModifier
implements IAttachmentModifier<Ignite, Ignite> {
    public static final String ID = GunProperties.IGNITE.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Ignite> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new IgniteJsonProperty(data.getIgnite());
    }

    @Override
    public CacheValue<Ignite> initCache(ItemStack gunItem, GunData gunData) {
        Ignite ignite = gunData.getBulletData().getIgnite();
        return new CacheValue<Ignite>(ignite);
    }

    @Override
    public void eval(List<Ignite> modifiedValues, CacheValue<Ignite> cache) {
        Ignite cacheValue = cache.getValue();
        ArrayList igniteEntityValues = Lists.newArrayList();
        igniteEntityValues.add(cacheValue.isIgniteEntity());
        ArrayList igniteBlockValues = Lists.newArrayList();
        igniteBlockValues.add(cacheValue.isIgniteBlock());
        modifiedValues.forEach(v -> {
            igniteEntityValues.add(v.isIgniteEntity());
            igniteBlockValues.add(v.isIgniteBlock());
        });
        boolean igniteEntity = AttachmentPropertyManager.eval(igniteEntityValues, false);
        boolean igniteBlock = AttachmentPropertyManager.eval(igniteBlockValues, false);
        cache.setValue(new Ignite(igniteEntity, igniteBlock));
    }

    private static class Data {
        @SerializedName(value="ignite")
        private Ignite ignite = new Ignite(false);

        private Data() {
        }

        @Nullable
        public Ignite getIgnite() {
            return this.ignite;
        }
    }

    public static class IgniteJsonProperty
    extends JsonProperty<Ignite> {
        public IgniteJsonProperty(Ignite value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Ignite value = (Ignite)this.getValue();
            if (value == null) {
                return;
            }
            if (value.isIgniteEntity()) {
                this.components.add(Component.translatable((String)"tooltip.tacz.attachment.ignite.entity").withStyle(ChatFormatting.GREEN));
            }
            if (value.isIgniteBlock()) {
                this.components.add(Component.translatable((String)"tooltip.tacz.attachment.ignite.block").withStyle(ChatFormatting.GREEN));
            }
        }
    }
}

