/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AdsModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.ADS_TIME.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getOptionalFields() {
        return "ads_addend";
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        Modifier ads = data.getAds();
        if (ads == null) {
            ads = new Modifier();
            ads.setAddend(data.getAdsAddendTime());
        }
        return new AdsJsonProperty(ads);
    }

    @Override
    public CacheValue<Float> initCache(ItemStack gunItem, GunData gunData) {
        return new CacheValue<Float>(Float.valueOf(gunData.getAimTime()));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float aimTime = gunData.getAimTime();
        float modifiedAimTime = ((Float)cacheProperty.getCache(ID)).floatValue();
        float adsTimeModifier = modifiedAimTime - aimTime;
        double percent = Math.min((double)gunData.getAimTime() / 0.5, 1.0);
        double adsTimeModifierPercent = Math.min((double)adsTimeModifier / 0.5, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.ads";
        String positivelyString = String.format("%.2fs \u00a7c(+%.2f)", Float.valueOf(modifiedAimTime), Float.valueOf(adsTimeModifier));
        String negativelyString = String.format("%.2fs \u00a7a(%.2f)", Float.valueOf(modifiedAimTime), Float.valueOf(adsTimeModifier));
        String defaultString = String.format("%.2fs", Float.valueOf(modifiedAimTime));
        boolean positivelyBetter = false;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, adsTimeModifierPercent, Float.valueOf(adsTimeModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @Nullable
        @SerializedName(value="ads")
        private Modifier ads;
        @SerializedName(value="ads_addend")
        @Deprecated
        private float adsAddendTime = 0.0f;

        @Nullable
        public Modifier getAds() {
            return this.ads;
        }

        @Deprecated
        public float getAdsAddendTime() {
            return this.adsAddendTime;
        }
    }

    public static class AdsJsonProperty
    extends JsonProperty<Modifier> {
        public AdsJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            float adsAddendTime = 0.0f;
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 0.2);
                adsAddendTime = (float)(eval - 0.2);
            }
            if (adsAddendTime > 0.0f) {
                this.components.add(Component.translatable((String)"tooltip.tacz.attachment.ads.increase").withStyle(ChatFormatting.RED));
            } else if (adsAddendTime < 0.0f) {
                this.components.add(Component.translatable((String)"tooltip.tacz.attachment.ads.decrease").withStyle(ChatFormatting.GREEN));
            }
        }
    }
}

