/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.resource.ResourceManager;
import com.tacz.guns.config.PreLoadConfig;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.DelegatingPackResources;
import com.tacz.guns.resource.PackMeta;
import com.tacz.guns.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public enum GunPackLoader implements RepositorySource
{
    INSTANCE;

    private static final Marker MARKER;
    public PackType packType;
    private boolean firstLoad = true;

    public void loadPacks(Consumer<Pack> pOnLoad) {
        Pack extensionsPack = this.discoverExtensions();
        if (extensionsPack != null) {
            pOnLoad.accept(extensionsPack);
        }
    }

    public Pack discoverExtensions() {
        Path resourcePacksPath = FMLPaths.GAMEDIR.get().resolve("tacz");
        File folder = resourcePacksPath.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                GunMod.LOGGER.warn(MARKER, "Failed to init tacz resource directory...", (Throwable)e);
                return null;
            }
        }
        if (this.firstLoad) {
            if (!((Boolean)PreLoadConfig.override.get()).booleanValue()) {
                for (ResourceManager.ExtraEntry entry : ResourceManager.EXTRA_ENTRIES) {
                    GetJarResources.copyModDirectory(entry.modMainClass(), entry.srcPath(), resourcePacksPath, entry.extraDirName());
                }
            }
            this.firstLoad = false;
        }
        GunMod.LOGGER.info(MARKER, "Start scanning for gun packs in {}", (Object)resourcePacksPath);
        List<GunPack> gunPacks = GunPackLoader.scanExtensions(resourcePacksPath);
        GunMod.LOGGER.info(MARKER, "Found {} possible gunpack(s) and added them to resource set.", (Object)gunPacks.size());
        ArrayList<PackResources> extensionPacks = new ArrayList<PackResources>();
        for (GunPack gunPack : gunPacks) {
            PackResources packResources = Files.isDirectory(gunPack.path, new LinkOption[0]) ? new PathPackResources.PathResourcesSupplier(gunPack.path).openPrimary(new PackLocationInfo(gunPack.name, (Component)Component.literal((String)gunPack.name), PackSource.BUILT_IN, Optional.empty())) : new FilePackResources.FileResourcesSupplier(gunPack.path).openPrimary(new PackLocationInfo(gunPack.name, (Component)Component.literal((String)gunPack.name), PackSource.BUILT_IN, Optional.empty()));
            extensionPacks.add(packResources);
        }
        PackLocationInfo info = new PackLocationInfo("tacz_resources", (Component)Component.literal((String)"TACZ Resources"), PackSource.BUILT_IN, Optional.empty());
        PackMetadataSection meta = new PackMetadataSection((Component)Component.translatable((String)"tacz.resources.modresources"), SharedConstants.getCurrentVersion().getPackVersion(this.packType), Optional.empty());
        DelegatingPackResources pack = new DelegatingPackResources(this, info, meta, extensionPacks){

            @Override
            public IoSupplier<InputStream> getRootResource(String ... paths) {
                Path logoPath;
                if (paths.length == 1 && paths[0].equals("pack.png") && (logoPath = GunPackLoader.getModIcon("tacz")) != null) {
                    return IoSupplier.create((Path)logoPath);
                }
                return null;
            }
        };
        PackSelectionConfig config = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);
        return Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)pack, (PackType)this.packType, (PackSelectionConfig)config);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Path logoPath;
        IModInfo mod;
        IModFile file;
        Optional m = ModList.get().getModContainerById(modId);
        if (m.isPresent() && (file = (mod = ((ModContainer)m.get()).getModInfo()).getOwningFile().getFile()) != null && Files.exists(logoPath = file.findResource(new String[]{"icon.png"}), new LinkOption[0])) {
            return logoPath;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromDirPath(Path path) throws IOException {
        Path packInfoFilePath = path.resolve("gunpack.meta.json");
        try (InputStream stream = Files.newInputStream(packInfoFilePath, new OpenOption[0]);){
            PackMeta info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
            if (info == null) {
                GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath.getFileName());
                GunPack gunPack = null;
                return gunPack;
            }
            if (info.getDependencies() != null && !GunPackLoader.modVersionAllMatch(info)) {
                GunMod.LOGGER.warn(MARKER, "Mod version mismatch: {}", (Object)packInfoFilePath.getFileName());
                GunPack gunPack = null;
                return gunPack;
            }
            GunPack gunPack = new GunPack(path, info.getName());
            return gunPack;
        }
        catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException exception) {
            GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath.getFileName());
            GunMod.LOGGER.warn(exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromZipPath(Path path) {
        try {
            block23: {
                block22: {
                    block21: {
                        zipFile = new ZipFile(path.toFile());
                        extDescriptorEntry = zipFile.getEntry("gunpack.meta.json");
                        if (extDescriptorEntry == null) {
                            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)"No gunpack.meta.json found");
                            var3_5 = null;
                        }
                        ** GOTO lbl14
                        {
                            catch (Throwable var2_4) {
                                throw var2_4;
                            }
                            zipFile.close();
                            return var3_5;
lbl14:
                            // 1 sources

                            stream = zipFile.getInputStream(extDescriptorEntry);
                            try {
                                info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
                                if (info == null) {
                                    GunMod.LOGGER.warn(GunPackLoader.MARKER, "Failed to read info json: {}", (Object)path.getFileName());
                                    var5_11 = null;
                                    if (stream == null) break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var4_10) {}
                            ** try [egrp 8[TRYBLOCK] [24 : 215->265)] { 
lbl25:
                            // 1 sources

                            try {
                                if (stream == null) throw var4_10;
                                try {
                                    stream.close();
                                    throw var4_10;
                                }
                                catch (Throwable var5_14) {
                                    var4_10.addSuppressed(var5_14);
                                }
                                throw var4_10;
                            }
                            catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException e) {
                                GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)e);
                                return null;
                            }
lbl36:
                            // 1 sources

                            finally {
                                zipFile.close();
                            }
                        }
                        stream.close();
                    }
                    zipFile.close();
                    return var5_11;
lbl-1000:
                    // 1 sources

                    {
                        if (info.getDependencies() == null || GunPackLoader.modVersionAllMatch(info)) ** GOTO lbl-1000
                        GunMod.LOGGER.warn(GunPackLoader.MARKER, "Mod version mismatch: {}", (Object)path.getFileName());
                        var5_12 = null;
                        if (stream == null) break block22;
                    }
                    stream.close();
                }
                zipFile.close();
                return var5_12;
lbl-1000:
                // 1 sources

                {
                    var5_13 = new GunPack(path, info.getName());
                    if (stream == null) break block23;
                }
                stream.close();
            }
            zipFile.close();
            return var5_13;
        }
        catch (IOException e) {
            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)e);
            return null;
        }
    }

    private static List<GunPack> scanExtensions(Path extensionsPath) {
        ArrayList<GunPack> gunPacks = new ArrayList<GunPack>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionsPath);){
            for (Path entry : stream) {
                GunPack gunPack = null;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    gunPack = GunPackLoader.fromDirPath(entry);
                } else if (entry.toString().endsWith(".zip")) {
                    gunPack = GunPackLoader.fromZipPath(entry);
                }
                if (gunPack == null) continue;
                GunMod.LOGGER.info(MARKER, "- {}, Main namespace: {}", (Object)gunPack.path.getFileName(), (Object)gunPack.name);
                gunPacks.add(gunPack);
            }
        }
        catch (IOException e) {
            GunMod.LOGGER.error(MARKER, "Failed to scan extensions from {}. Error: {}", (Object)extensionsPath, (Object)e);
        }
        return gunPacks;
    }

    private static boolean modVersionAllMatch(PackMeta info) throws InvalidVersionSpecificationException {
        HashMap<String, String> dependencies = info.getDependencies();
        for (String modId : dependencies.keySet()) {
            if (GunPackLoader.modVersionMatch(modId, dependencies.get(modId))) continue;
            return false;
        }
        return true;
    }

    private static boolean modVersionMatch(String modId, String version) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
        return ModList.get().getModContainerById(modId).map(mod -> {
            ArtifactVersion modVersion = mod.getModInfo().getVersion();
            return versionRange.containsVersion(modVersion);
        }).orElse(false);
    }

    static {
        MARKER = MarkerManager.getMarker((String)"GunPackFinder");
    }

    public record GunPack(Path path, String name) {
    }
}

