/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageRefreshRefitScreen;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientMessageUnloadAttachment
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientMessageUnloadAttachment> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"client_unload_attachment"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientMessageUnloadAttachment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, message -> message.gunSlotIndex, (StreamCodec)ByteBufCodecs.fromCodec(AttachmentType.CODEC), message -> message.attachmentType, ClientMessageUnloadAttachment::new);
    private final int gunSlotIndex;
    private final AttachmentType attachmentType;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientMessageUnloadAttachment(int gunSlotIndex, AttachmentType attachmentType) {
        this.gunSlotIndex = gunSlotIndex;
        this.attachmentType = attachmentType;
    }

    public static void handle(ClientMessageUnloadAttachment message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack attachmentItem;
            ServerPlayer player = (ServerPlayer)context.player();
            Inventory inventory = player.getInventory();
            ItemStack gunItem = inventory.getItem(message.gunSlotIndex);
            IGun iGun = IGun.getIGunOrNull(gunItem);
            if (iGun != null && !(attachmentItem = iGun.getAttachment((HolderLookup.Provider)player.registryAccess(), gunItem, message.attachmentType)).isEmpty() && inventory.add(attachmentItem)) {
                iGun.unloadAttachment((HolderLookup.Provider)player.registryAccess(), gunItem, message.attachmentType);
                AttachmentPropertyManager.postChangeEvent((LivingEntity)player, gunItem);
                if (message.attachmentType == AttachmentType.EXTENDED_MAG) {
                    iGun.dropAllAmmo((Player)player, gunItem);
                }
                player.inventoryMenu.broadcastChanges();
                NetworkHandler.sendToClientPlayer(ServerMessageRefreshRefitScreen.INSTANCE, (Player)player);
            }
        });
    }
}

