/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientMessageLaserColor
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientMessageLaserColor> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"client_laser_color"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientMessageLaserColor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.idMapper(AttachmentType::fromId, Enum::ordinal), (StreamCodec)ByteBufCodecs.INT), message -> message.colorMap, (StreamCodec)ByteBufCodecs.BOOL, message -> message.applyGunColor, (StreamCodec)ByteBufCodecs.INT, message -> message.gunColor, (StreamCodec)ByteBufCodecs.INT, message -> message.gunSlotIndex, (colorMap, applyGunColor, gunColor, gunSlotIndex) -> {
        ClientMessageLaserColor message = new ClientMessageLaserColor();
        message.colorMap.putAll((Map<AttachmentType, Integer>)colorMap);
        message.applyGunColor = applyGunColor;
        message.gunColor = gunColor;
        message.gunSlotIndex = gunSlotIndex;
        return message;
    });
    private final Map<AttachmentType, Integer> colorMap = new HashMap<AttachmentType, Integer>();
    private boolean applyGunColor = false;
    private int gunColor = 0;
    private int gunSlotIndex = -1;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private ClientMessageLaserColor() {
    }

    public ClientMessageLaserColor(@NotNull ItemStack gun, int gunSlotIndex) {
        AttachmentType[] attachmentTypeArray = gun.getItem();
        if (attachmentTypeArray instanceof IGun) {
            IGun iGun = (IGun)attachmentTypeArray;
            for (AttachmentType type : AttachmentType.values()) {
                IAttachment iAttachment;
                ItemStack attachment = iGun.getAttachment((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), gun, type);
                Item item = attachment.getItem();
                if (!(item instanceof IAttachment) || !(iAttachment = (IAttachment)item).hasCustomLaserColor(attachment)) continue;
                this.colorMap.put(type, iAttachment.getLaserColor(attachment));
            }
            if (iGun.hasCustomLaserColor(gun)) {
                this.gunColor = iGun.getLaserColor(gun);
                this.applyGunColor = true;
            }
            this.gunSlotIndex = gunSlotIndex;
        }
    }

    public static void handle(ClientMessageLaserColor message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (message.gunSlotIndex == -1) {
                return;
            }
            Inventory inventory = player.getInventory();
            ItemStack gunItem = inventory.getItem(message.gunSlotIndex);
            IGun iGun = IGun.getIGunOrNull(gunItem);
            if (iGun != null) {
                for (Map.Entry<AttachmentType, Integer> entry : message.colorMap.entrySet()) {
                    AttachmentType type = entry.getKey();
                    int color = entry.getValue();
                    CompoundTag tag = iGun.getAttachmentTag(gunItem, type);
                    if (tag != null) {
                        AttachmentItemDataAccessor.setLaserColorToTag(tag, color);
                    }
                    iGun.setAttachmentTag(gunItem, type, tag);
                }
                if (message.applyGunColor) {
                    iGun.setLaserColor(gunItem, message.gunColor);
                }
            }
        });
    }
}

