/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.entity.TargetMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class TargetMinecartItem
extends Item {
    public TargetMinecartItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (!level.isClientSide) {
            RailShape railShape;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double yOffset = 0.0;
            if (railshape.isAscending()) {
                yOffset = 0.5;
            }
            TargetMinecart targetMinecart = new TargetMinecart(level, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + yOffset, (double)blockpos.getZ() + 0.5);
            if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                targetMinecart.setCustomName(itemstack.getHoverName());
            }
            level.addFreshEntity((Entity)targetMinecart);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        itemstack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

