/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.command.sub.DebugCommand;
import com.tacz.guns.debug.GunMeleeDebug;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.item.ModernKineticGunScriptAPI;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.EffectData;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.MarkerManager;
import org.joml.Vector2d;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;

public class ModernKineticGunItem
extends AbstractGunItem
implements GunItemDataAccessor {
    public static final String TYPE_NAME = "modern_kinetic";
    private static final DoubleFunction<AttributeModifier> AM_FACTORY = amount -> new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"melee_damage"), amount, AttributeModifier.Operation.ADD_VALUE);
    public final DefaultPropertyModification defaultPropertyModification = new DefaultPropertyModification();

    public ModernKineticGunItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public boolean startBolt(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public boolean tickBolt(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElseGet(() -> this.defaultTickBolt(api));
    }

    @Override
    public void shoot(ShooterDataHolder dataHolder, ItemStack gunItem, Supplier<Float> pitch, Supplier<Float> yaw, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        api.setPitchSupplier(pitch);
        api.setYawSupplier(yaw);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("shoot"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api)), () -> api.shootOnce(api.isShootingNeedConsumeAmmo()));
    }

    @Override
    public boolean startReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_reload"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public ReloadState tickReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return new ReloadState();
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_reload"))).map(func -> {
            ReloadState reloadState = new ReloadState();
            Varargs varargs = func.invoke((Varargs)CoerceJavaToLua.coerce((Object)api));
            int typeOrdinary = varargs.arg(1).checkint();
            long countDown = varargs.arg(2).checklong();
            reloadState.setStateType(ReloadState.StateType.values()[typeOrdinary]);
            reloadState.setCountDown(countDown);
            return reloadState;
        }).orElseGet(() -> this.defaultTickReload(api));
    }

    @Override
    public void interruptReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("interrupt_reload"))).ifPresent(func -> func.call(CoerceJavaToLua.coerce((Object)api)));
    }

    @Override
    public void melee(ShooterDataHolder dataHolder, LivingEntity user, ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            GunMeleeData meleeData = gunIndex.getGunData().getMeleeData();
            float distance = meleeData.getDistance();
            ResourceLocation muzzleId = this.getAttachmentId(gunItem, AttachmentType.MUZZLE);
            MeleeData muzzleData = this.getMeleeData(muzzleId);
            if (muzzleData != null) {
                this.doMelee(user, distance, muzzleData.getDistance(), muzzleData.getRangeAngle(), muzzleData.getKnockback(), muzzleData.getDamage(), muzzleData.getEffects());
                return;
            }
            ResourceLocation stockId = this.getAttachmentId(gunItem, AttachmentType.STOCK);
            MeleeData stockData = this.getMeleeData(stockId);
            if (stockData != null) {
                this.doMelee(user, distance, stockData.getDistance(), stockData.getRangeAngle(), stockData.getKnockback(), stockData.getDamage(), stockData.getEffects());
                return;
            }
            GunDefaultMeleeData defaultData = meleeData.getDefaultMeleeData();
            if (defaultData == null) {
                return;
            }
            this.doMelee(user, distance, defaultData.getDistance(), defaultData.getRangeAngle(), defaultData.getKnockback(), defaultData.getDamage(), Collections.emptyList());
        });
    }

    @Override
    public void tickHeat(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        long heatTimestamp = dataHolder.heatTimestamp;
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_heat"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((double)heatTimestamp)), () -> this.defaultTickHeat(heatTimestamp, gunItem));
    }

    private void defaultTickHeat(long heatTimestamp, ItemStack gunItem) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem)).map(index -> index.getGunData().getHeatData()).ifPresent(heatData -> {
            if (iGun.getHeatAmount(gunItem) <= 0.0f) {
                return;
            }
            if (iGun.isOverheatLocked(gunItem)) {
                this.tickLocked(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            } else {
                this.tickNormal(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            }
        });
    }

    public void tickLocked(IGun iGun, ItemStack gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getOverHeatTime()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
            if (heatAmount <= 0.0f) {
                iGun.setOverheatLocked(gunStack, false);
            }
        }
    }

    public void tickNormal(IGun iGun, ItemStack gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getCoolingDelay()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
        }
    }

    @Override
    public <T> T modifyProperty(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter, String luaMethodName, String id, Class<T> type, T original) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return original;
        }
        Object afterDefaultModification = this.defaultPropertyModification.modify(gunItem, shooter, gunIndex, id, original);
        try {
            return (T)Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get(luaMethodName))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((String)id), CoerceJavaToLua.coerce((Object)afterDefaultModification))).map(luaValue -> type.cast(CoerceLuaToJava.coerce((LuaValue)luaValue, (Class)type))).orElse(afterDefaultModification);
        }
        catch (Exception exception) {
            GunMod.LOGGER.warn(MarkerManager.getMarker((String)"Gun Script"), "Failed to modify gun property {}", (Object)id, (Object)exception);
            return afterDefaultModification;
        }
    }

    @Override
    public void doBulletSpread(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter, Projectile projectile, int bulletCnt, float processedSpeed, float inaccuracy, float pitch, float yaw) {
        if (!(projectile instanceof EntityKineticBullet)) {
            return;
        }
        EntityKineticBullet bullet = (EntityKineticBullet)projectile;
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("calcSpread"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((int)bulletCnt), (LuaValue)LuaValue.valueOf((double)inaccuracy))).map(luaValue -> {
            if (luaValue.istable()) {
                LuaTable table = luaValue.checktable();
                return new Vector2d(table.get(1).checkdouble(), table.get(2).checkdouble());
            }
            return null;
        }).ifPresentOrElse(vector2d -> bullet.shootFromRotation((Entity)shooter, pitch, yaw, 0.0f, processedSpeed, (Vector2d)vector2d), () -> bullet.shootFromRotation((Entity)shooter, pitch, yaw, 0.0f, processedSpeed, inaccuracy));
    }

    private boolean defaultTickBolt(ModernKineticGunScriptAPI api) {
        long boltFeedTime;
        GunData gunData = api.getGunIndex().getGunData();
        long boltActionTime = (long)(gunData.getBoltActionTime() * 1000.0f);
        float rawBoltFeedTime = gunData.getBoltFeedTime();
        long l = boltFeedTime = rawBoltFeedTime == -1.0f ? boltActionTime : (long)(gunData.getBoltFeedTime() * 1000.0f);
        if (api.getBoltTime() < boltFeedTime) {
            return true;
        }
        if (!api.hasAmmoInBarrel()) {
            if (api.useInventoryAmmo()) {
                if (api.consumeAmmoFromPlayer(1) == 1) {
                    api.setAmmoInBarrel(true);
                }
            } else if (api.removeAmmoFromMagazine(1) != 0) {
                api.setAmmoInBarrel(true);
            }
        }
        return api.getBoltTime() < boltActionTime;
    }

    private ReloadState defaultTickReload(ModernKineticGunScriptAPI api) {
        long countDown;
        ReloadState.StateType stateType;
        CommonGunIndex gunIndex = api.getGunIndex();
        GunData gunData = gunIndex.getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        ReloadState.StateType oldStateType = ReloadState.StateType.values()[api.getReloadStateType()];
        long progressTime = api.getReloadTime();
        if (oldStateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else if (oldStateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else {
            stateType = ReloadState.StateType.NOT_RELOADING;
            countDown = -1L;
        }
        if (oldStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, false);
        }
        if (oldStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, true);
        }
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }

    private void defaultReloadFinishing(ModernKineticGunScriptAPI api, boolean isTactical) {
        int i;
        GunData data = api.getGunIndex().getGunData();
        int needAmmoCount = api.getNeededAmmoAmount();
        boolean needConsumeAmmo = api.isReloadingNeedConsumeAmmo();
        boolean infinite = data.getReloadData().isInfinite();
        needConsumeAmmo = needConsumeAmmo || infinite;
        switch (data.getReloadData().getType()) {
            case MAGAZINE: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(needAmmoCount);
                    api.putAmmoInMagazine(consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
            case FUEL: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(1);
                    api.putAmmoInMagazine(needAmmoCount * consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
        }
        Bolt boltType = api.getGunIndex().getGunData().getBolt();
        if (!(isTactical || boltType != Bolt.MANUAL_ACTION && boltType != Bolt.CLOSED_BOLT || (i = api.removeAmmoFromMagazine(1)) == 0)) {
            api.setAmmoInBarrel(true);
        }
    }

    private void doMelee(LivingEntity user, float gunDistance, float meleeDistance, float rangeAngle, float knockback, float damage, List<EffectData> effects) {
        double distance = gunDistance + meleeDistance;
        float xRot = (float)Math.toRadians(-user.getXRot());
        float yRot = (float)Math.toRadians(-user.getYRot());
        Vec3 eyeVec = new Vec3(0.0, 0.0, 1.0).xRot(xRot).yRot(yRot).normalize().scale(distance);
        Vec3 centrePos = user.getEyePosition().subtract(eyeVec);
        List entityList = user.level().getEntitiesOfClass(LivingEntity.class, user.getBoundingBox().inflate(distance));
        com.google.common.base.Supplier realDamage = Suppliers.memoize(() -> {
            AttributeInstance instance = user.getAttribute(Attributes.ATTACK_DAMAGE);
            if (instance == null) {
                return Float.valueOf(damage);
            }
            double oldBase = instance.getBaseValue();
            AttributeModifier modifier = AM_FACTORY.apply(damage);
            try {
                instance.setBaseValue(0.0);
                instance.addTransientModifier(modifier);
                Float f = Float.valueOf((float)instance.getValue());
                return f;
            }
            finally {
                instance.setBaseValue(oldBase);
                instance.removeModifier(modifier);
            }
        });
        for (LivingEntity living : entityList) {
            double degree;
            Vec3 targetVec = living.getEyePosition().subtract(centrePos);
            double targetLength = targetVec.length();
            if (targetLength < distance || !((degree = Math.toDegrees(Math.acos(targetVec.dot(eyeVec) / (targetLength * distance)))) < (double)(rangeAngle / 2.0f)) || !user.hasLineOfSight((Entity)living)) continue;
            ModernKineticGunItem.doPerLivingHurt(user, living, knockback, ((Float)realDamage.get()).floatValue(), effects);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.causeFoodExhaustion(0.1f);
        }
        if (DebugCommand.DEBUG) {
            GunMeleeDebug.showRange(user, (int)Math.round(distance), centrePos, eyeVec, rangeAngle);
        }
    }

    private static void doPerLivingHurt(LivingEntity user, LivingEntity target, float knockback, float damage, List<EffectData> effects) {
        Object serverLevel;
        DamageSource source;
        if (target.equals((Object)user)) {
            return;
        }
        target.knockback((double)knockback, (double)((float)Math.sin(Math.toRadians(user.getYRot()))), (double)((float)(-Math.cos(Math.toRadians(user.getYRot())))));
        if (user instanceof Player) {
            Player player = (Player)user;
            source = user.damageSources().playerAttack(player);
        } else {
            source = user.damageSources().mobAttack(user);
        }
        target.hurt(source, damage);
        Level level = target.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)source);
        }
        if (!target.isAlive()) {
            return;
        }
        for (EffectData effectData : effects) {
            Holder mobEffect = BuiltInRegistries.MOB_EFFECT.getHolder(effectData.getEffectId()).orElse(null);
            if (mobEffect == null) continue;
            int time = Math.max(0, effectData.getTime() * 20);
            int amplifier = Math.max(0, effectData.getAmplifier());
            MobEffectInstance effectInstance = new MobEffectInstance(mobEffect, time, amplifier, false, effectData.isHideParticles());
            target.addEffect(effectInstance);
        }
        Level level2 = user.level();
        if (level2 instanceof ServerLevel) {
            serverLevel = (ServerLevel)level2;
            int n = (int)((double)damage * 0.5);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), n, 0.1, 0.0, 0.1, 0.2);
        }
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }

    private LuaFunction checkFunction(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return (LuaFunction)luaValue;
        }
        if (luaValue.isnil()) {
            return null;
        }
        throw new LuaError("bad argument: function or nil expected, got " + luaValue.typename());
    }

    @Override
    public void fireSelect(ShooterDataHolder dataHolder, ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> {
            FireMode fireMode = this.getFireMode(gunItem);
            List<FireMode> fireModeSet = gunIndex.getGunData().getFireModeSet();
            int nextIndex = (fireModeSet.indexOf((Object)fireMode) + 1) % fireModeSet.size();
            FireMode nextFireMode = fireModeSet.get(nextIndex);
            this.setFireMode(gunItem, nextFireMode);
            return nextFireMode;
        });
    }

    @Override
    public int getLevel(int exp) {
        return 0;
    }

    @Override
    public int getExp(int level) {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }

    public class DefaultPropertyModification {
        public static final ResourceLocation SLUGS = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"intrinsic/slug");

        public <T> T modify(ItemStack gunItem, LivingEntity shooter, CommonGunIndex gunIndex, String id, T original) {
            if ("bullet_amount".equals(id) && AllowAttachmentTagMatcher.matchTag(SLUGS, ModernKineticGunItem.this.getAttachmentId(gunItem, AttachmentType.EXTENDED_MAG))) {
                return (T)Integer.valueOf(1);
            }
            return original;
        }
    }
}

