/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.client.renderer.item.GunSmithTableItemRenderer;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import com.tacz.guns.resource.index.CommonBlockIndex;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class GunSmithTableItem
extends BlockItem
implements BlockItemDataAccessor {
    public GunSmithTableItem(Block block) {
        super(block, new Item.Properties().stacksTo(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return GunSmithTableItemRenderer.INSTANCE;
            }
        });
    }

    public static NonNullList<ItemStack> fillItemCategory() {
        NonNullList stacks = NonNullList.create();
        TimelessAPI.getAllCommonBlockIndex().forEach(blockIndex -> {
            ItemStack stack = BlockItemBuilder.create((ItemLike)((CommonBlockIndex)blockIndex.getValue()).getBlock()).setId((ResourceLocation)blockIndex.getKey()).build();
            stacks.add((Object)stack);
        });
        return stacks;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component getName(@Nonnull ItemStack stack) {
        ResourceLocation blockId = this.getBlockId(stack);
        Optional<ClientBlockIndex> blockIndex = TimelessAPI.getClientBlockIndex(blockId);
        if (blockIndex.isPresent()) {
            return Component.translatable((String)blockIndex.get().getName());
        }
        return super.getName(stack);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return Optional.of(new BlockItemTooltip(this.getBlockId(pStack)));
    }
}

