/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.renderer.item.AttachmentItemRenderer;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.inventory.tooltip.AttachmentItemTooltip;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.util.datafixer.AttachmentIdFix;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class AttachmentItem
extends Item
implements AttachmentItemDataAccessor {
    public AttachmentItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component getName(@Nonnull ItemStack stack) {
        ResourceLocation attachmentId = this.getAttachmentId(stack);
        Optional<ClientAttachmentIndex> attachmentIndex = TimelessAPI.getClientAttachmentIndex(attachmentId);
        if (attachmentIndex.isPresent()) {
            return Component.translatable((String)attachmentIndex.get().getName());
        }
        return super.getName(stack);
    }

    private static Comparator<Map.Entry<ResourceLocation, CommonAttachmentIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonAttachmentIndex)m.getValue()).getSort());
    }

    public static NonNullList<ItemStack> fillItemCategory(AttachmentType type) {
        NonNullList stacks = NonNullList.create();
        TimelessAPI.getAllCommonAttachmentIndex().stream().sorted(AttachmentItem.idNameSort()).forEach(entry -> {
            if (((CommonAttachmentIndex)entry.getValue()).getPojo().isHidden()) {
                return;
            }
            if (type.equals((Object)((CommonAttachmentIndex)entry.getValue()).getType())) {
                ItemStack itemStack = AttachmentItemBuilder.create().setId((ResourceLocation)entry.getKey()).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return AttachmentItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    @Nonnull
    public AttachmentType getType(ItemStack attachmentStack) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentStack);
        if (iAttachment != null) {
            ResourceLocation id = iAttachment.getAttachmentId(attachmentStack);
            return TimelessAPI.getCommonAttachmentIndex(id).map(CommonAttachmentIndex::getType).orElse(AttachmentType.NONE);
        }
        return AttachmentType.NONE;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new AttachmentItemTooltip(this.getAttachmentId(stack), this.getType(stack), stack));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(this::verifyTagAfterLoad));
    }

    public void verifyTagAfterLoad(@NotNull CompoundTag tag) {
        AttachmentIdFix.updateAttachmentIdInTag(tag);
    }
}

