/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.event;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.item.ModernKineticGunScriptAPI;
import com.tacz.guns.resource.pojo.data.gun.FeedType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber
public class PlayerRespawnEvent {
    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!((Boolean)GunConfig.AUTO_RELOAD_WHEN_RESPAWN.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        player.getInventory().items.forEach(itemStack -> {
            boolean useInventoryAmmo;
            if (!(itemStack.getItem() instanceof IGun)) {
                return;
            }
            ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
            api.setItemStack((ItemStack)itemStack);
            api.setShooter((LivingEntity)player);
            boolean bl = useInventoryAmmo = api.getGunIndex().getGunData().getReloadData().getType() == FeedType.INVENTORY;
            if (useInventoryAmmo) {
                return;
            }
            boolean isFuel = api.getGunIndex().getGunData().getReloadData().getType() == FeedType.FUEL;
            int needAmmoCount = api.getNeededAmmoAmount();
            if (player.isCreative()) {
                api.putAmmoInMagazine(needAmmoCount);
            } else {
                int consumedAmount = api.consumeAmmoFromPlayer(isFuel ? 1 : needAmmoCount);
                api.putAmmoInMagazine(isFuel ? needAmmoCount * consumedAmount : consumedAmount);
            }
        });
    }
}

