/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.sync.core;

import com.tacz.guns.entity.sync.core.IDataSerializer;
import com.tacz.guns.entity.sync.core.SyncedClassKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public record SyncedDataKey<E extends Entity, T>(Pair<ResourceLocation, ResourceLocation> pairKey, ResourceLocation id, SyncedClassKey<E> classKey, IDataSerializer<T> serializer, Supplier<T> defaultValueSupplier, boolean save, boolean persistent, SyncMode syncMode) {
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncedDataKey<?, ?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, key -> key.classKey().id(), (StreamCodec)ResourceLocation.STREAM_CODEC, SyncedDataKey::id, (classKey, dataKey) -> {
        SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey((ResourceLocation)classKey);
        if (syncedClassKey == null) {
            return null;
        }
        SyncedDataKey<?, ?> syncedDataKey = SyncedEntityData.instance().getKey(syncedClassKey, (ResourceLocation)dataKey);
        if (syncedDataKey == null || !syncedDataKey.save()) {
            return null;
        }
        return syncedDataKey;
    });

    public static <E extends Entity, T> Builder<E, T> builder(SyncedClassKey<E> entityClass, IDataSerializer<T> serializer) {
        return new Builder<E, T>(entityClass, serializer);
    }

    public void setValue(E entity, T value) {
        SyncedEntityData.instance().set(entity, this, value);
    }

    public T getValue(E entity) {
        return SyncedEntityData.instance().get(entity, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncedDataKey that = (SyncedDataKey)o;
        return Objects.equals(this.pairKey, that.pairKey);
    }

    @Override
    public int hashCode() {
        return this.pairKey.hashCode();
    }

    public static enum SyncMode {
        NONE(false, false),
        ALL(true, true),
        TRACKING_ONLY(true, false),
        SELF_ONLY(false, true);

        final boolean tracking;
        final boolean self;

        private SyncMode(boolean tracking, boolean self) {
            this.tracking = tracking;
            this.self = self;
        }

        public boolean isTracking() {
            return this.tracking;
        }

        public boolean isSelf() {
            return this.self;
        }
    }

    public static class Builder<E extends Entity, T> {
        private final SyncedClassKey<E> classKey;
        private final IDataSerializer<T> serializer;
        private ResourceLocation id;
        private Supplier<T> defaultValueSupplier;
        private boolean save = false;
        private boolean persistent = true;
        private SyncMode syncMode = SyncMode.ALL;

        private Builder(SyncedClassKey<E> classKey, IDataSerializer<T> serializer) {
            this.classKey = classKey;
            this.serializer = serializer;
        }

        public SyncedDataKey<E, T> build() {
            Validate.notNull((Object)this.id, (String)"Missing 'id' when building synced data key", (Object[])new Object[0]);
            Validate.notNull(this.defaultValueSupplier, (String)"Missing 'defaultValueSupplier' when building synced data key", (Object[])new Object[0]);
            Pair pairKey = Pair.of((Object)this.classKey.id(), (Object)this.id);
            return new SyncedDataKey<E, T>((Pair<ResourceLocation, ResourceLocation>)pairKey, this.id, this.classKey, this.serializer, this.defaultValueSupplier, this.save, this.persistent, this.syncMode);
        }

        public Builder<E, T> id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder<E, T> id(String id) {
            this.id = ResourceLocation.parse((String)id);
            return this;
        }

        @Deprecated
        public Builder<E, T> key(String key) {
            return this.id(key);
        }

        public Builder<E, T> defaultValueSupplier(Supplier<T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            return this;
        }

        public Builder<E, T> saveToFile() {
            this.save = true;
            return this;
        }

        public Builder<E, T> resetOnDeath() {
            this.persistent = false;
            return this;
        }

        public Builder<E, T> syncMode(SyncMode mode) {
            this.syncMode = mode;
            return this;
        }
    }
}

