/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.sync.core;

import com.tacz.guns.entity.sync.core.IDataSerializer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Serializers {
    public static final IDataSerializer<Boolean> BOOLEAN = new IDataSerializer<Boolean>(){

        @Override
        public void write(FriendlyByteBuf buf, Boolean value) {
            buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean read(FriendlyByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Boolean value) {
            return ByteTag.valueOf((boolean)value);
        }

        @Override
        public Boolean read(HolderLookup.Provider provider, Tag tag) {
            return ((ByteTag)tag).getAsByte() != 0;
        }
    };
    public static final IDataSerializer<Byte> BYTE = new IDataSerializer<Byte>(){

        @Override
        public void write(FriendlyByteBuf buf, Byte value) {
            buf.writeByte(value.byteValue());
        }

        @Override
        public Byte read(FriendlyByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Byte value) {
            return ByteTag.valueOf((byte)value);
        }

        @Override
        public Byte read(HolderLookup.Provider provider, Tag tag) {
            return ((ByteTag)tag).getAsByte();
        }
    };
    public static final IDataSerializer<Short> SHORT = new IDataSerializer<Short>(){

        @Override
        public void write(FriendlyByteBuf buf, Short value) {
            buf.writeShort((int)value.shortValue());
        }

        @Override
        public Short read(FriendlyByteBuf buf) {
            return buf.readShort();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Short value) {
            return ShortTag.valueOf((short)value);
        }

        @Override
        public Short read(HolderLookup.Provider provider, Tag tag) {
            return ((ShortTag)tag).getAsShort();
        }
    };
    public static final IDataSerializer<Integer> INTEGER = new IDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value.intValue());
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Integer value) {
            return IntTag.valueOf((int)value);
        }

        @Override
        public Integer read(HolderLookup.Provider provider, Tag tag) {
            return ((IntTag)tag).getAsInt();
        }
    };
    public static final IDataSerializer<Long> LONG = new IDataSerializer<Long>(){

        @Override
        public void write(FriendlyByteBuf buf, Long value) {
            buf.writeLong(value.longValue());
        }

        @Override
        public Long read(FriendlyByteBuf buf) {
            return buf.readLong();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Long value) {
            return LongTag.valueOf((long)value);
        }

        @Override
        public Long read(HolderLookup.Provider provider, Tag tag) {
            return ((LongTag)tag).getAsLong();
        }
    };
    public static final IDataSerializer<Float> FLOAT = new IDataSerializer<Float>(){

        @Override
        public void write(FriendlyByteBuf buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(FriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Float value) {
            return FloatTag.valueOf((float)value.floatValue());
        }

        @Override
        public Float read(HolderLookup.Provider provider, Tag tag) {
            return Float.valueOf(((FloatTag)tag).getAsFloat());
        }
    };
    public static final IDataSerializer<Double> DOUBLE = new IDataSerializer<Double>(){

        @Override
        public void write(FriendlyByteBuf buf, Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double read(FriendlyByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Double value) {
            return DoubleTag.valueOf((double)value);
        }

        @Override
        public Double read(HolderLookup.Provider provider, Tag tag) {
            return ((DoubleTag)tag).getAsDouble();
        }
    };
    public static final IDataSerializer<Character> CHARACTER = new IDataSerializer<Character>(){

        @Override
        public void write(FriendlyByteBuf buf, Character value) {
            buf.writeChar((int)value.charValue());
        }

        @Override
        public Character read(FriendlyByteBuf buf) {
            return Character.valueOf(buf.readChar());
        }

        @Override
        public Tag write(HolderLookup.Provider provider, Character value) {
            return IntTag.valueOf((int)value.charValue());
        }

        @Override
        public Character read(HolderLookup.Provider provider, Tag tag) {
            return Character.valueOf((char)((IntTag)tag).getAsInt());
        }
    };
    public static final IDataSerializer<String> STRING = new IDataSerializer<String>(){

        @Override
        public void write(FriendlyByteBuf buf, String value) {
            buf.writeUtf(value);
        }

        @Override
        public String read(FriendlyByteBuf buf) {
            return buf.readUtf();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, String value) {
            return StringTag.valueOf((String)value);
        }

        @Override
        public String read(HolderLookup.Provider provider, Tag tag) {
            return tag.getAsString();
        }
    };
    public static final IDataSerializer<CompoundTag> TAG_COMPOUND = new IDataSerializer<CompoundTag>(){

        @Override
        public void write(FriendlyByteBuf buf, CompoundTag value) {
            buf.writeNbt((Tag)value);
        }

        @Override
        public CompoundTag read(FriendlyByteBuf buf) {
            return buf.readNbt();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, CompoundTag value) {
            return value;
        }

        @Override
        public CompoundTag read(HolderLookup.Provider provider, Tag tag) {
            return (CompoundTag)tag;
        }
    };
    public static final IDataSerializer<BlockPos> BLOCK_POS = new IDataSerializer<BlockPos>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockPos value) {
            buf.writeBlockPos(value);
        }

        @Override
        public BlockPos read(FriendlyByteBuf buf) {
            return buf.readBlockPos();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, BlockPos value) {
            return LongTag.valueOf((long)value.asLong());
        }

        @Override
        public BlockPos read(HolderLookup.Provider provider, Tag tag) {
            return BlockPos.of((long)((LongTag)tag).getAsLong());
        }
    };
    public static final IDataSerializer<UUID> UUID = new IDataSerializer<UUID>(){

        @Override
        public void write(FriendlyByteBuf buf, UUID value) {
            buf.writeUUID(value);
        }

        @Override
        public UUID read(FriendlyByteBuf buf) {
            return buf.readUUID();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, UUID value) {
            CompoundTag compound = new CompoundTag();
            compound.putLong("Most", value.getMostSignificantBits());
            compound.putLong("Least", value.getLeastSignificantBits());
            return compound;
        }

        @Override
        public UUID read(HolderLookup.Provider provider, Tag tag) {
            CompoundTag compound = (CompoundTag)tag;
            return new UUID(compound.getLong("Most"), compound.getLong("Least"));
        }
    };
    public static final IDataSerializer<ItemStack> ITEM_STACK = new IDataSerializer<ItemStack>(){

        @Override
        public void write(FriendlyByteBuf buf, ItemStack value) {
            buf.writeJsonWithCodec(ItemStack.CODEC, (Object)value);
        }

        @Override
        public ItemStack read(FriendlyByteBuf buf) {
            return (ItemStack)buf.readJsonWithCodec(ItemStack.CODEC);
        }

        @Override
        public Tag write(HolderLookup.Provider provider, ItemStack value) {
            return value.save(provider, (Tag)new CompoundTag());
        }

        @Override
        public ItemStack read(HolderLookup.Provider provider, Tag tag) {
            return ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)tag));
        }
    };
    public static final IDataSerializer<ResourceLocation> RESOURCE_LOCATION = new IDataSerializer<ResourceLocation>(){

        @Override
        public void write(FriendlyByteBuf buf, ResourceLocation value) {
            buf.writeResourceLocation(value);
        }

        @Override
        public ResourceLocation read(FriendlyByteBuf buf) {
            return buf.readResourceLocation();
        }

        @Override
        public Tag write(HolderLookup.Provider provider, ResourceLocation value) {
            return StringTag.valueOf((String)value.toString());
        }

        @Override
        public ResourceLocation read(HolderLookup.Provider provider, Tag tag) {
            return ResourceLocation.tryParse((String)tag.getAsString());
        }
    };
}

