/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import com.google.common.collect.Lists;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.entity.KnockBackModifier;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.particle.AmmoParticleSpawner;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.particles.BulletHoleOption;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.DamageModifier;
import com.tacz.guns.resource.modifier.custom.ExplosionModifier;
import com.tacz.guns.resource.modifier.custom.IgniteModifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.util.EntityUtil;
import com.tacz.guns.util.ExplodeUtil;
import com.tacz.guns.util.TacHitResult;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.entity.PartEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class EntityKineticBullet
extends Projectile
implements IEntityWithComplexSpawn {
    public static final EntityType<EntityKineticBullet> TYPE = EntityType.Builder.of(EntityKineticBullet::new, (MobCategory)MobCategory.MISC).noSummon().noSave().fireImmune().sized(0.0625f, 0.0625f).clientTrackingRange(5).updateInterval(5).setShouldReceiveVelocityUpdates(false).build("bullet");
    public static final TagKey<EntityType<?>> USE_MAGIC_DAMAGE_ON = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"tacz:use_magic_damage_on"));
    public static final TagKey<EntityType<?>> USE_VOID_DAMAGE_ON = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"tacz:use_void_damage_on"));
    public static final TagKey<EntityType<?>> PRETEND_MELEE_DAMAGE_ON = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"tacz:pretend_melee_damage_on"));
    public static final String TRACER_COLOR_OVERRIDER_KEY = "tacz:tracer_override";
    public static final String TRACER_SIZE_OVERRIDER_KEY = "tacz:tracer_size";
    private static final ExplosionData DEFAULT_EXPLOSION_DATA = new ExplosionData(false, 0.0f, 0.0f, false, 30.0f, false);
    private ResourceLocation ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    @Deprecated
    private float speed = 1.0f;
    private float gravity = 0.0f;
    private float friction = 0.01f;
    private LinkedList<ExtraDamage.DistanceDamagePair> damageAmount = Lists.newLinkedList();
    private float distanceAmount = 0.0f;
    private float knockback = 0.0f;
    private boolean explosion = false;
    private boolean igniteEntity = false;
    private boolean igniteBlock = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3.0f;
    private float explosionRadius = 3.0f;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private boolean explosionDestroyBlock = false;
    private float damageModifier = 1.0f;
    private int pierce = 1;
    private Vec3 startPos;
    private boolean isTracerAmmo;
    private float cameraXRot;
    private float cameraYRot;
    private Vector3f firstPersonRenderOffset;
    private ResourceLocation gunId;
    private ResourceLocation gunDisplayId;
    private float armorIgnore;
    private float headShot;

    public EntityKineticBullet(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(EntityType<? extends Projectile> type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.setPos(x, y, z);
    }

    public EntityKineticBullet(Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, ResourceLocation gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, gunDisplayId, isTracerAmmo, gunData, bulletData);
    }

    public EntityKineticBullet(Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID, isTracerAmmo, gunData, bulletData);
    }

    protected EntityKineticBullet(EntityType<? extends Projectile> type, Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, ResourceLocation gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(type, throwerIn.getX(), throwerIn.getEyeY() - (double)0.1f, throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
        this.gunId = gunId;
        AttachmentCacheProperty cacheProperty = Objects.requireNonNull(IGunOperator.fromLivingEntity(throwerIn).getCacheProperty());
        float armorIgnore = this.modifyProperty(GunProperties.ARMOR_IGNORE, Float.class, cacheProperty.getCache(GunProperties.ARMOR_IGNORE)).floatValue();
        float headshot = this.modifyProperty(GunProperties.HEADSHOT_MULTIPLIER, Float.class, cacheProperty.getCache(GunProperties.HEADSHOT_MULTIPLIER)).floatValue();
        float knockback = this.modifyProperty(GunProperties.KNOCKBACK, Float.class, cacheProperty.getCache(GunProperties.KNOCKBACK)).floatValue();
        this.armorIgnore = Mth.clamp((float)armorIgnore, (float)0.0f, (float)1.0f);
        this.headShot = Math.max(headshot, 0.0f);
        this.knockback = Math.max(knockback, 0.0f);
        this.ammoId = ammoId;
        float lifeSecond = this.modifyProperty("bullet_life", Float.class, Float.valueOf(bulletData.getLifeSecond())).floatValue();
        this.life = Mth.clamp((int)((int)(lifeSecond * 20.0f)), (int)1, (int)Integer.MAX_VALUE);
        this.gravity = Mth.clamp((float)this.modifyProperty("bullet_gravity", Float.class, Float.valueOf(bulletData.getGravity())).floatValue(), (float)0.0f, (float)Float.MAX_VALUE);
        this.friction = Mth.clamp((float)this.modifyProperty("bullet_friction", Float.class, Float.valueOf(bulletData.getFriction())).floatValue(), (float)0.0f, (float)Float.MAX_VALUE);
        Ignite ignite = (Ignite)cacheProperty.getCache(IgniteModifier.ID);
        this.igniteEntity = this.modifyProperty("ignite_entity", Boolean.class, Boolean.valueOf(bulletData.getIgnite().isIgniteEntity() || ignite.isIgniteEntity()));
        this.igniteEntityTime = Math.max(this.modifyProperty("ignite_entity_time", Integer.class, Integer.valueOf(bulletData.getIgniteEntityTime())), 0);
        this.igniteBlock = this.modifyProperty("ignite_block", Boolean.class, Boolean.valueOf(bulletData.getIgnite().isIgniteBlock() || ignite.isIgniteBlock()));
        this.damageAmount = (LinkedList)cacheProperty.getCache(DamageModifier.ID);
        this.distanceAmount = this.modifyProperty(GunProperties.EFFECTIVE_RANGE, Float.class, cacheProperty.getCache(GunProperties.EFFECTIVE_RANGE)).floatValue();
        int pierce = this.modifyProperty(GunProperties.PIERCE, Integer.class, cacheProperty.getCache(GunProperties.PIERCE));
        this.pierce = Mth.clamp((int)pierce, (int)1, (int)Integer.MAX_VALUE);
        ExplosionData explosionData = Objects.requireNonNullElse((ExplosionData)cacheProperty.getCache(ExplosionModifier.ID), DEFAULT_EXPLOSION_DATA);
        this.explosion = this.modifyProperty("explode_enabled", Boolean.class, Boolean.valueOf(explosionData.isExplode()));
        if (this.explosion) {
            Float explosionDamage = this.modifyProperty("explosion_damage", Float.class, Float.valueOf(explosionData.getDamage()));
            Float explosionRadius = this.modifyProperty("explosion_radius", Float.class, Float.valueOf(explosionData.getRadius()));
            this.explosionDamage = (float)Mth.clamp((double)((double)explosionDamage.floatValue() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)3.4028234663852886E38);
            this.explosionRadius = Mth.clamp((float)explosionRadius.floatValue(), (float)0.0f, (float)Float.MAX_VALUE);
            this.explosionKnockback = this.modifyProperty("explosion_knockback", Boolean.class, Boolean.valueOf(explosionData.isKnockback()));
            int delayTickCount = (int)(this.modifyProperty("explosion_delay", Float.class, Float.valueOf(explosionData.getDelay())).floatValue() * 20.0f);
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDestroyBlock = (Boolean)AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCK.get() != false && this.modifyProperty("explosion_destroys_block", Boolean.class, Boolean.valueOf(explosionData.isDestroyBlock())) != false;
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        double posX = throwerIn.xOld + (throwerIn.getX() - throwerIn.xOld) / 2.0;
        double posY = throwerIn.yOld + (throwerIn.getY() - throwerIn.yOld) / 2.0 + (double)throwerIn.getEyeHeight();
        double posZ = throwerIn.zOld + (throwerIn.getZ() - throwerIn.zOld) / 2.0;
        this.setPos(posX, posY, posZ);
        this.startPos = this.position();
        this.isTracerAmmo = isTracerAmmo;
        this.gunDisplayId = gunDisplayId;
    }

    @ApiStatus.Internal
    public void applyShotgunDamageSpread(int bulletCount) {
        if (bulletCount > 1) {
            this.damageModifier = 1.0f / (float)bulletCount;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        this.onBulletTick();
        if (this.level().isClientSide && FMLEnvironment.dist == Dist.CLIENT) {
            AmmoParticleSpawner.addParticle(this);
        }
        Vec3 movement = this.getDeltaMovement();
        double x = movement.x;
        double y = movement.y;
        double z = movement.z;
        double distance = movement.horizontalDistance();
        this.setYRot((float)Math.toDegrees(Mth.atan2((double)x, (double)z)));
        this.setXRot((float)Math.toDegrees(Mth.atan2((double)y, (double)distance)));
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        this.setXRot(EntityKineticBullet.lerpRotation((float)this.xRotO, (float)this.getXRot()));
        this.setYRot(EntityKineticBullet.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        double nextPosX = this.getX() + x;
        double nextPosY = this.getY() + y;
        double nextPosZ = this.getZ() + z;
        this.setPos(nextPosX, nextPosY, nextPosZ);
        float friction = this.friction;
        float gravity = this.gravity;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, nextPosX - x * 0.25, nextPosY - y * 0.25, nextPosZ - z * 0.25, x, y, z);
            }
            friction = 0.4f;
            gravity *= 0.6f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)(1.0f - friction)));
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-gravity), 0.0));
        if (this.tickCount >= this.life - 1) {
            this.discard();
        }
    }

    protected void onBulletTick() {
        if (!this.level().isClientSide()) {
            if (this.explosion) {
                if (this.explosionDelayCount > 0) {
                    --this.explosionDelayCount;
                } else {
                    ExplodeUtil.createExplosion(this.getOwner(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, this.position());
                    this.discard();
                    return;
                }
            }
            Vec3 startVec = this.position();
            Vec3 endVec = startVec.add(this.getDeltaMovement());
            Object result = BlockRayTrace.rayTraceBlocks(this.level(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockHitResult resultB = result;
            if (resultB.getType() != HitResult.Type.MISS) {
                endVec = resultB.getLocation();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.explosion) {
                EntityResult entityResult = EntityUtil.findEntityOnPath(this, startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = EntityUtil.findEntitiesOnPath(this, startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; (i < this.pierce || i < 1) && i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.distanceTo(startVec) < hitEntityResult[k].hitVec.distanceTo(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult)((Object)result), startVec, endVec);
                    --this.pierce;
                    if (this.pierce >= 1 && !this.explosion) continue;
                    this.discard();
                    return;
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    public void shoot(double pitch, double yaw, float pVelocity, Vector2d vector2d) {
        Vector3d left = new Vector3d(vector2d.x, vector2d.y, 8.0);
        left.rotateX(pitch * 0.01745329238474369);
        left.rotateY(-yaw * 0.01745329238474369);
        Vec3 vec3 = new Vec3(left.x, left.y, left.z).normalize().scale((double)pVelocity);
        this.setDeltaMovement(vec3.x, vec3.y, vec3.z);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, Vector2d vector2d) {
        this.shoot(pX, pY, pVelocity, vector2d);
        Vec3 vec3 = pShooter.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, pShooter.onGround() ? 0.0 : vec3.y, vec3.z));
    }

    protected void onHitEntity(TacHitResult result, Vec3 startVec, Vec3 endVec) {
        KnockBackModifier modifier;
        LivingEntity livingCore;
        Entity entity;
        float headShotMultiplier;
        Entity entity2 = result.getEntity();
        if (entity2 instanceof ITargetEntity) {
            ITargetEntity targetEntity = (ITargetEntity)entity2;
            DamageSource source = this.damageSources().thrown((Entity)this, this.getOwner());
            targetEntity.onProjectileHit((Entity)this, result, source, this.getDamage(result.getLocation()));
            return;
        }
        Entity entity3 = result.getEntity();
        @Nullable Entity owner = this.getOwner();
        LivingEntity attacker = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        Pair sources = this.createDamageSources(MaybeMultipartEntity.of(entity3));
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.getLocation());
        EntityHurtByGunEvent.Pre preEvent = new EntityHurtByGunEvent.Pre((Entity)this, entity3, attacker, this.gunId, this.gunDisplayId, damage, sources, headshot, headShotMultiplier = Math.max(this.headShot, 0.0f), LogicalSide.SERVER);
        boolean cancelled = ((EntityHurtByGunEvent.Pre)NeoForge.EVENT_BUS.post((Event)preEvent)).isCanceled();
        if (cancelled) {
            return;
        }
        entity3 = preEvent.getHurtEntity();
        MaybeMultipartEntity parts = MaybeMultipartEntity.of(entity3);
        attacker = preEvent.getAttacker();
        ResourceLocation newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        sources = Pair.of((Object)preEvent.getDamageSource(GunDamageSourcePart.NON_ARMOR_PIERCING), (Object)preEvent.getDamageSource(GunDamageSourcePart.ARMOR_PIERCING));
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity3 == null) {
            return;
        }
        if (this.igniteEntity && ((Boolean)AmmoConfig.IGNITE_ENTITY.get()).booleanValue()) {
            entity3.setRemainingFireTicks(this.igniteEntityTime);
            entity = this.level();
            if (entity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, entity3.getX(), entity3.getY() + (double)entity3.getEyeHeight(), entity3.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (headshot) {
            damage *= headShotMultiplier;
        }
        if ((entity = parts.core()) instanceof LivingEntity) {
            livingCore = (LivingEntity)entity;
            modifier = KnockBackModifier.fromLivingEntity(livingCore);
            modifier.setKnockBackStrength(this.knockback);
            this.tacAttackEntity(parts, damage, (Pair<DamageSource, DamageSource>)sources);
            modifier.resetKnockBackStrength();
        } else {
            this.tacAttackEntity(parts, damage, (Pair<DamageSource, DamageSource>)sources);
        }
        if (this.explosion) {
            parts.core().invulnerableTime = 0;
            ExplodeUtil.createExplosion(this.getOwner(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, result.getLocation());
        }
        if ((modifier = parts.core()) instanceof LivingEntity) {
            livingCore = (LivingEntity)modifier;
            if (!this.level().isClientSide) {
                int attackerId;
                int n = attackerId = attacker == null ? 0 : attacker.getId();
                if (livingCore.isDeadOrDying()) {
                    NeoForge.EVENT_BUS.post((Event)new EntityKillByGunEvent((Entity)this, livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<DamageSource, DamageSource>)sources, headshot, headShotMultiplier, LogicalSide.SERVER));
                    NetworkHandler.sendToDimension(new ServerMessageGunKill(this.getId(), livingCore.getId(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (Entity)livingCore);
                } else {
                    NeoForge.EVENT_BUS.post((Event)new EntityHurtByGunEvent.Post((Entity)this, (Entity)livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<DamageSource, DamageSource>)sources, headshot, headShotMultiplier, LogicalSide.SERVER));
                    NetworkHandler.sendToDimension(new ServerMessageGunHurt(this.getId(), livingCore.getId(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (Entity)livingCore);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result, Vec3 startVec, Vec3 endVec) {
        if (result.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        Vec3 hitVec = result.getLocation();
        if (((AmmoHitBlockEvent)NeoForge.EVENT_BUS.post((Event)new AmmoHitBlockEvent(this.level(), result, this.level().getBlockState(pos), this))).isCanceled()) {
            return;
        }
        super.onHitBlock(result);
        if (this.explosion) {
            ExplodeUtil.createExplosion(this.getOwner(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, hitVec);
            this.discard();
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.getDirection(), result.getBlockPos(), this.ammoId.toString(), this.gunId.toString(), this.gunDisplayId.toString());
            serverLevel.sendParticles((ParticleOptions)bulletHoleOption, hitVec.x, hitVec.y, hitVec.z, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.igniteBlock) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, hitVec.x, hitVec.y, hitVec.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.igniteBlock && ((Boolean)AmmoConfig.IGNITE_BLOCK.get()).booleanValue()) {
            BlockPos offsetPos = pos.relative(result.getDirection());
            if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)offsetPos, (Direction)result.getDirection())) {
                BlockState fireState = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)offsetPos);
                this.level().setBlock(offsetPos, fireState, 11);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.LAVA, hitVec.x - 1.0 + this.random.nextDouble() * 2.0, hitVec.y, hitVec.z - 1.0 + this.random.nextDouble() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.discard();
    }

    public float getDamage(Vec3 hitVec) {
        float base = 0.0f;
        double playerDistance = hitVec.distanceTo(this.startPos);
        for (ExtraDamage.DistanceDamagePair pair : this.damageAmount) {
            float f = this.damageAmount.get(0).getDistance() == pair.getDistance() ? this.distanceAmount : pair.getDistance();
            float effectiveDistance = f;
            if (!(playerDistance < (double)effectiveDistance)) continue;
            float damage = pair.getDamage();
            base = Math.max(damage * this.damageModifier, 0.0f);
            break;
        }
        return this.modifyProperty(GunProperties.DAMAGE, Float.class, Float.valueOf(base)).floatValue();
    }

    private <T> T modifyProperty(GunProperty<?> prop, Class<T> type, T original) {
        return this.modifyProperty(prop.name(), type, original);
    }

    private <T> T modifyProperty(String id, Class<T> type, T original) {
        AbstractGunItem gunInterface;
        LivingEntity shooter;
        ItemStack gun;
        Item item;
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity && (item = (gun = (shooter = (LivingEntity)entity).getMainHandItem()).getItem()) instanceof AbstractGunItem && Objects.equals(this.gunId, (gunInterface = (AbstractGunItem)item).getGunId(gun))) {
            ShooterDataHolder dataHolder = IGunOperator.fromLivingEntity(shooter).getDataHolder();
            return (T)gunInterface.modifyProperty(dataHolder, gun, shooter, id, type, original);
        }
        return original;
    }

    private Pair<DamageSource, DamageSource> createDamageSources(MaybeMultipartEntity parts) {
        DamageSource source1;
        DamageSource source2;
        EntityKineticBullet directCause;
        EntityType hitPartType = parts.hitPart().getType();
        EntityKineticBullet entityKineticBullet = directCause = hitPartType.is(PRETEND_MELEE_DAMAGE_ON) ? this.getOwner() : this;
        if (hitPartType.is(USE_MAGIC_DAMAGE_ON)) {
            source1 = source2 = this.damageSources().indirectMagic((Entity)this, this.getOwner());
        } else if (hitPartType.is(USE_VOID_DAMAGE_ON)) {
            source1 = ModDamageTypes.Sources.bulletVoid(this.registryAccess(), (Entity)directCause, this.getOwner(), false);
            source2 = ModDamageTypes.Sources.bulletVoid(this.registryAccess(), (Entity)directCause, this.getOwner(), true);
        } else {
            source1 = ModDamageTypes.Sources.bullet(this.registryAccess(), (Entity)directCause, this.getOwner(), false);
            source2 = ModDamageTypes.Sources.bullet(this.registryAccess(), (Entity)directCause, this.getOwner(), true);
        }
        return Pair.of((Object)source1, (Object)source2);
    }

    private void tacAttackEntity(MaybeMultipartEntity parts, float damage, Pair<DamageSource, DamageSource> sources) {
        DamageSource source1 = (DamageSource)sources.getLeft();
        DamageSource source2 = (DamageSource)sources.getRight();
        float armorDamagePercent = Mth.clamp((float)this.armorIgnore, (float)0.0f, (float)1.0f);
        float normalDamagePercent = 1.0f - armorDamagePercent;
        parts.core().invulnerableTime = 0;
        parts.hitPart().hurt(source1, damage * normalDamagePercent);
        parts.core().invulnerableTime = 0;
        parts.hitPart().hurt(source2, damage * armorDamagePercent);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeFloat(this.getXRot());
        buffer.writeFloat(this.getYRot());
        buffer.writeDouble(this.getDeltaMovement().x);
        buffer.writeDouble(this.getDeltaMovement().y);
        buffer.writeDouble(this.getDeltaMovement().z);
        Entity entity = this.getOwner();
        buffer.writeInt(entity != null ? entity.getId() : 0);
        buffer.writeResourceLocation(this.ammoId);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.explosion);
        buffer.writeBoolean(this.igniteEntity);
        buffer.writeBoolean(this.igniteBlock);
        buffer.writeFloat(this.explosionRadius);
        buffer.writeFloat(this.explosionDamage);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.friction);
        buffer.writeInt(this.pierce);
        buffer.writeBoolean(this.isTracerAmmo);
        buffer.writeResourceLocation(this.gunId);
        buffer.writeResourceLocation(this.gunDisplayId);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setXRot(additionalData.readFloat());
        this.setYRot(additionalData.readFloat());
        this.setDeltaMovement(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        Entity entity = this.level().getEntity(additionalData.readInt());
        if (entity != null) {
            this.setOwner(entity);
        }
        this.ammoId = additionalData.readResourceLocation();
        this.gravity = additionalData.readFloat();
        this.explosion = additionalData.readBoolean();
        this.igniteEntity = additionalData.readBoolean();
        this.igniteBlock = additionalData.readBoolean();
        this.explosionRadius = additionalData.readFloat();
        this.explosionDamage = additionalData.readFloat();
        this.life = additionalData.readInt();
        this.speed = additionalData.readFloat();
        this.friction = additionalData.readFloat();
        this.pierce = additionalData.readInt();
        this.isTracerAmmo = additionalData.readBoolean();
        this.gunId = additionalData.readResourceLocation();
        this.gunDisplayId = additionalData.readResourceLocation();
    }

    public ResourceLocation getAmmoId() {
        return this.ammoId;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    public ResourceLocation getGunDisplayId() {
        return this.gunDisplayId;
    }

    public boolean isTracerAmmo() {
        return this.isTracerAmmo;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public float getCameraYRot() {
        return this.cameraYRot;
    }

    public void setCameraYRot(float cameraYRot) {
        this.cameraYRot = cameraYRot;
    }

    public float getCameraXRot() {
        return this.cameraXRot;
    }

    public void setCameraXRot(float cameraXRot) {
        this.cameraXRot = cameraXRot;
    }

    public Vector3f getFirstPersonRenderOffset() {
        return this.firstPersonRenderOffset;
    }

    public void setFirstPersonRenderOffset(Vector3f originRenderOffset) {
        this.firstPersonRenderOffset = originRenderOffset;
    }

    public Optional<float[]> getTracerColorOverride() {
        CompoundTag pd = this.getPersistentData();
        if (!pd.contains(TRACER_COLOR_OVERRIDER_KEY, 11)) {
            return Optional.empty();
        }
        int[] ints = pd.getIntArray(TRACER_COLOR_OVERRIDER_KEY);
        switch (ints.length) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                float albedo = (float)ints[0] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, 1.0f});
            }
            case 2: {
                float albedo = (float)ints[0] / 255.0f;
                float alpha = (float)ints[1] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, alpha});
            }
            case 3: {
                float r = (float)ints[0] / 255.0f;
                float g = (float)ints[1] / 255.0f;
                float b = (float)ints[2] / 255.0f;
                return Optional.of(new float[]{r, g, b, 1.0f});
            }
        }
        float r = (float)ints[0] / 255.0f;
        float g = (float)ints[1] / 255.0f;
        float b = (float)ints[2] / 255.0f;
        float a = (float)ints[3] / 255.0f;
        return Optional.of(new float[]{r, g, b, a});
    }

    public float getTracerSizeOverride() {
        CompoundTag pd = this.getPersistentData();
        return pd.contains(TRACER_SIZE_OVERRIDER_KEY, 99) ? pd.getFloat(TRACER_SIZE_OVERRIDER_KEY) : 1.0f;
    }

    public boolean ownedBy(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return super.ownedBy(entity);
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }

    public record MaybeMultipartEntity(Entity hitPart, Entity core) {
        public static MaybeMultipartEntity of(Entity hitPart) {
            Entity entity;
            if (hitPart instanceof PartEntity) {
                PartEntity part = (PartEntity)hitPart;
                entity = part.getParent();
            } else {
                entity = hitPart;
            }
            Entity core = entity;
            return new MaybeMultipartEntity(hitPart, core);
        }
    }
}

