/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting.result;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawGunTableResult {
    private final String type;
    private final int count;
    private final ResourceLocation id;
    @Nullable
    private GunResult extraData;
    @Nullable
    private CompoundTag nbt;

    public RawGunTableResult(@NotNull String type, @NotNull ResourceLocation id, int count) {
        this.type = type;
        this.id = id;
        this.count = count;
    }

    public void setExtraData(@Nullable GunResult extraData) {
        this.extraData = extraData;
    }

    public void setNbt(@Nullable CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static GunSmithTableResult init(HolderLookup.Provider provider, RawGunTableResult raw) {
        GunSmithTableResult result;
        switch (raw.type) {
            case "gun": {
                GunSmithTableResult gunSmithTableResult = raw.getGunStack(provider);
                break;
            }
            case "ammo": {
                GunSmithTableResult gunSmithTableResult = raw.getAmmoStack();
                break;
            }
            case "attachment": {
                GunSmithTableResult gunSmithTableResult = raw.getAttachmentStack();
                break;
            }
            default: {
                GunSmithTableResult gunSmithTableResult = result = new GunSmithTableResult(ItemStack.EMPTY, TabConfig.TAB_EMPTY);
            }
        }
        if (raw.nbt != null) {
            result.getResult().update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
                for (String key : raw.nbt.getAllKeys()) {
                    Tag value = raw.nbt.get(key);
                    if (value == null) continue;
                    tag.put(key, value);
                }
            }));
        }
        return result;
    }

    private GunSmithTableResult getGunStack(HolderLookup.Provider provider) {
        EnumMap<AttachmentType, Object> attachments;
        int ammoCount;
        if (this.extraData != null) {
            ammoCount = Math.max(0, this.extraData.getAmmoCount());
            attachments = this.extraData.getAttachments();
        } else {
            ammoCount = 0;
            attachments = new EnumMap(AttachmentType.class);
        }
        return TimelessAPI.getCommonGunIndex(this.id).map(gunIndex -> {
            ItemStack itemStack = GunItemBuilder.create().setCount(this.count).setId(this.id).setAmmoCount(ammoCount).setAmmoInBarrel(false).putAllAttachment(attachments).setFireMode(gunIndex.getGunData().getFireModeSet().get(0)).build(provider);
            Object raw = gunIndex.getType();
            if (!((String)raw).contains(":")) {
                raw = "tacz:" + (String)raw;
            }
            ResourceLocation group = ResourceLocation.tryParse((String)raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(ItemStack.EMPTY, TabConfig.TAB_EMPTY));
    }

    private GunSmithTableResult getAmmoStack() {
        return new GunSmithTableResult(AmmoItemBuilder.create().setCount(this.count).setId(this.id).build(), TabConfig.TAB_AMMO);
    }

    private GunSmithTableResult getAttachmentStack() {
        return TimelessAPI.getCommonAttachmentIndex(this.id).map(attachmentIndex -> {
            ItemStack itemStack = AttachmentItemBuilder.create().setCount(this.count).setId(this.id).build();
            Object raw = attachmentIndex.getType().name().toLowerCase(Locale.US);
            if (!((String)raw).contains(":")) {
                raw = "tacz:" + (String)raw;
            }
            ResourceLocation group = ResourceLocation.tryParse((String)raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(ItemStack.EMPTY, TabConfig.TAB_EMPTY));
    }
}

