/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting.result;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.tacz.guns.crafting.result.RawGunTableResult;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableResult {
    public static final Codec<GunSmithTableResult> CODEC = ExtraCodecs.catchDecoderException((Codec)Codec.of(GunSmithTableResult::encode, GunSmithTableResult::decode));
    public static final StreamCodec<RegistryFriendlyByteBuf, GunSmithTableResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, GunSmithTableResult::getResult, (StreamCodec)ResourceLocation.STREAM_CODEC, GunSmithTableResult::getGroup, GunSmithTableResult::new);
    public static final String GUN = "gun";
    public static final String AMMO = "ammo";
    public static final String ATTACHMENT = "attachment";
    public static final String CUSTOM = "custom";
    private ItemStack result = ItemStack.EMPTY;
    private ResourceLocation group = null;
    @Nullable
    private RawGunTableResult raw = null;

    public static <T> DataResult<T> encode(GunSmithTableResult input, DynamicOps<T> ops, T prefix) {
        throw new UnsupportedOperationException();
    }

    public static <T> DataResult<Pair<GunSmithTableResult, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).map(map -> {
            GunSmithTableResult result;
            String typeName = (String)Codec.STRING.fieldOf("type").decode(ops, map).getOrThrow();
            int count = (Integer)Codec.INT.optionalFieldOf("count", (Object)1).decode(ops, map).getOrThrow();
            CompoundTag extraTag = (CompoundTag)CompoundTag.CODEC.optionalFieldOf("nbt", null).decode(ops, map).getOrThrow();
            ResourceLocation tabOverride = ((Optional)Codec.STRING.optionalFieldOf("group").decode(ops, map).getOrThrow()).map(raw -> raw.contains(":") ? raw : "tacz:" + raw).map(ResourceLocation::tryParse).orElse(null);
            switch (typeName) {
                case "gun": 
                case "ammo": 
                case "attachment": {
                    ResourceLocation id = (ResourceLocation)ResourceLocation.CODEC.fieldOf("id").decode(ops, map).getOrThrow();
                    RawGunTableResult raw2 = new RawGunTableResult(typeName, id, count);
                    if (extraTag != null) {
                        raw2.setNbt(extraTag);
                    }
                    if (typeName.equals(GUN)) {
                        GunResult.CODEC.parse(ops, input).result().ifPresent(raw2::setExtraData);
                    }
                    result = new GunSmithTableResult(raw2, tabOverride);
                    break;
                }
                case "custom": {
                    ItemStack itemStack = (ItemStack)ItemStack.OPTIONAL_CODEC.fieldOf("item").decode(ops, map).getOrThrow();
                    result = new GunSmithTableResult(itemStack, tabOverride);
                    if (extraTag == null) break;
                    result.getResult().update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
                        for (String key : extraTag.getAllKeys()) {
                            Tag value = extraTag.get(key);
                            if (value == null) continue;
                            tag.put(key, value);
                        }
                    }));
                    break;
                }
                default: {
                    result = new GunSmithTableResult(ItemStack.EMPTY, TabConfig.TAB_EMPTY);
                }
            }
            return Pair.of((Object)result, (Object)input);
        });
    }

    public GunSmithTableResult(ItemStack result, @Nullable ResourceLocation group) {
        this.result = result;
        this.group = group == null ? TabConfig.TAB_EMPTY : group;
    }

    public GunSmithTableResult(@NotNull RawGunTableResult raw) {
        this.raw = raw;
    }

    public GunSmithTableResult(@NotNull RawGunTableResult raw, @Nullable ResourceLocation group) {
        this.raw = raw;
        this.group = group == null ? TabConfig.TAB_EMPTY : group;
    }

    public void init(HolderLookup.Provider provider) {
        if (this.raw != null) {
            GunSmithTableResult result = RawGunTableResult.init(provider, this.raw);
            this.result = result.getResult();
            if (this.group == null || this.group.equals((Object)TabConfig.TAB_EMPTY)) {
                this.group = result.getGroup();
            }
            this.raw = null;
        }
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getGroup() {
        return this.group;
    }
}

