/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.init.ModIngredientTypes;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class NBTIngredient
implements ICustomIngredient {
    public static final MapCodec<NBTIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(NBTIngredient::items), (App)TagParser.LENIENT_CODEC.fieldOf("nbt").forGetter(NBTIngredient::nbt), (App)Codec.BOOL.optionalFieldOf("partial", (Object)true).forGetter(NBTIngredient::partial)).apply((Applicative)builder, NBTIngredient::new));
    private final HolderSet<Item> items;
    private final CompoundTag nbt;
    private final NbtPredicate predicate;
    private final boolean partial;
    private final ItemStack[] stacks;

    public NBTIngredient(HolderSet<Item> items, CompoundTag nbt, boolean partial) {
        this.items = items;
        this.nbt = nbt;
        this.predicate = new NbtPredicate(nbt);
        this.partial = partial;
        DataComponentPatch patch = DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt)).build();
        this.stacks = (ItemStack[])items.stream().map(i -> new ItemStack(i, 1, patch)).toArray(ItemStack[]::new);
    }

    public boolean test(@Nullable ItemStack itemStack) {
        CompoundTag nbt;
        if (itemStack == null) {
            return false;
        }
        if (!this.items.contains(itemStack.getItemHolder())) {
            return false;
        }
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = nbt = data != null ? data.copyTag() : null;
        if (this.partial) {
            return this.predicate.matches((Tag)nbt);
        }
        return Objects.equals(nbt, this.nbt);
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.NBT_INGREDIENT_TYPE.get();
    }

    public HolderSet<Item> items() {
        return this.items;
    }

    public CompoundTag nbt() {
        return this.nbt;
    }

    public boolean partial() {
        return this.partial;
    }
}

