/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.client.input.RefitKey;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.client.resource.pojo.display.gun.DamageStyle;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.item.GunTooltipPart;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientGunTooltip
implements ClientTooltipComponent {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##%");
    private static final DecimalFormat FORMAT_P_D1 = new DecimalFormat("#.#%");
    private static final DecimalFormat DAMAGE_FORMAT = new DecimalFormat("#.##");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("0%");
    private final ItemStack gun;
    private final IGun iGun;
    private final CommonGunIndex gunIndex;
    @Nullable
    private final GunDisplayInstance display;
    private final ItemStack ammo;
    @Nullable
    private List<FormattedCharSequence> desc;
    private Component ammoName;
    private MutableComponent ammoCountText;
    @Nullable
    private MutableComponent gunType;
    private MutableComponent damage;
    private MutableComponent armorIgnore;
    private MutableComponent headShotMultiplier;
    private MutableComponent weight;
    private MutableComponent tips;
    private MutableComponent levelInfo;
    @Nullable
    private MutableComponent packInfo;
    private int maxWidth;

    public ClientGunTooltip(GunTooltip tooltip) {
        this.gun = tooltip.getGun();
        this.iGun = tooltip.getIGun();
        ResourceLocation ammoId = tooltip.getAmmoId();
        this.gunIndex = tooltip.getGunIndex();
        this.display = TimelessAPI.getGunDisplay(this.gun).orElse(null);
        this.ammo = AmmoItemBuilder.create().setId(ammoId).build();
        this.maxWidth = 0;
        this.getText();
    }

    public int getHeight() {
        int height = 0;
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            height += 10 * this.desc.size() + 2;
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            height += 24;
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            height += 34;
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            height += 34;
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            height += 14;
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO)) {
            height += 14;
        }
        return height;
    }

    public int getWidth(Font font) {
        return this.maxWidth;
    }

    private void getText() {
        ResourceLocation gunId;
        PackInfo packInfoObject;
        String tooltip;
        Font font = Minecraft.getInstance().font;
        BulletData bulletData = this.gunIndex.getBulletData();
        GunData gunData = this.gunIndex.getGunData();
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && (tooltip = this.gunIndex.getPojo().getTooltip()) != null) {
            List split = font.split((FormattedText)Component.translatable((String)tooltip), 300);
            this.desc = split.size() > 3 ? split.subList(0, 3) : split;
            for (FormattedCharSequence sequence : this.desc) {
                this.maxWidth = Math.max(font.width(sequence), this.maxWidth);
            }
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            this.ammoName = this.ammo.getHoverName();
            this.maxWidth = Math.max(font.width((FormattedText)this.ammoName) + 22, this.maxWidth);
            int barrelBulletAmount = this.iGun.hasBulletInBarrel(this.gun) && this.gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.gun, this.gunIndex.getGunData()) + barrelBulletAmount;
            int currentAmmoCount = this.iGun.getCurrentAmmoCount(this.gun) + barrelBulletAmount;
            if (!this.iGun.useDummyAmmo(this.gun)) {
                this.ammoCountText = this.display != null && this.display.getAmmoCountStyle() == AmmoCountStyle.PERCENT ? Component.literal((String)CURRENT_AMMO_FORMAT_PERCENT.format((float)currentAmmoCount / (maxAmmoCount == 0 ? 1.0f : (float)maxAmmoCount))) : Component.literal((String)"%d/%d".formatted(currentAmmoCount, maxAmmoCount));
            } else {
                int dummyAmmoAmount = this.iGun.getDummyAmmoAmount(this.gun);
                if (this.display != null && this.display.getAmmoCountStyle() == AmmoCountStyle.PERCENT) {
                    String p = CURRENT_AMMO_FORMAT_PERCENT.format((float)currentAmmoCount / (maxAmmoCount == 0 ? 1.0f : (float)maxAmmoCount));
                    this.ammoCountText = Component.literal((String)"%s (%d)".formatted(p, dummyAmmoAmount));
                } else {
                    this.ammoCountText = Component.literal((String)"%d/%d (%d)".formatted(currentAmmoCount, maxAmmoCount, dummyAmmoAmount));
                }
            }
            if (this.iGun.useInventoryAmmo(this.gun)) {
                this.ammoCountText = Component.translatable((String)"tooltip.tacz.gun.inventory_mode").withStyle(ChatFormatting.YELLOW);
            }
            this.maxWidth = Math.max(font.width((FormattedText)this.ammoCountText) + 22, this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            int expToNextLevel = this.iGun.getExpToNextLevel(this.gun);
            int expCurrentLevel = this.iGun.getExpCurrentLevel(this.gun);
            int level = this.iGun.getLevel(this.gun);
            if (level >= this.iGun.getMaxLevel()) {
                levelText = String.format("%d (MAX)", level);
                this.levelInfo = Component.translatable((String)"tooltip.tacz.gun.level").append((Component)Component.literal((String)levelText).withStyle(ChatFormatting.DARK_PURPLE));
            } else {
                levelText = String.format("%d (%.1f%%)", level, Float.valueOf((float)(expCurrentLevel / (expToNextLevel + expCurrentLevel)) * 100.0f));
                this.levelInfo = Component.translatable((String)"tooltip.tacz.gun.level").append((Component)Component.literal((String)levelText).withStyle(ChatFormatting.YELLOW));
            }
            this.maxWidth = Math.max(font.width((FormattedText)this.levelInfo), this.maxWidth);
            String tabKey = "tacz.type." + this.gunIndex.getType() + ".name";
            this.gunType = Component.translatable((String)"tooltip.tacz.gun.type").append((Component)Component.translatable((String)tabKey).withStyle(ChatFormatting.AQUA));
            this.maxWidth = Math.max(font.width((FormattedText)this.gunType), this.maxWidth);
            double damage = AttachmentDataUtils.getDamageWithAttachment(this.gun, gunData);
            boolean hasSlugInstalled = AllowAttachmentTagMatcher.matchTag(ModernKineticGunItem.DefaultPropertyModification.SLUGS, this.iGun.getAttachmentId(this.gun, AttachmentType.EXTENDED_MAG));
            int bulletAmount = hasSlugInstalled ? 1 : gunData.getBulletData().getBulletAmount();
            MutableComponent value = this.display != null && this.display.getDamageStyle() == DamageStyle.PER_PROJECTILE && bulletAmount > 1 ? Component.literal((String)(DAMAGE_FORMAT.format(damage / (double)bulletAmount) + "x" + bulletAmount)).withStyle(ChatFormatting.AQUA) : Component.literal((String)DAMAGE_FORMAT.format(damage)).withStyle(ChatFormatting.AQUA);
            if (bulletData.getExplosionData() != null && (AttachmentDataUtils.isExplodeEnabled(this.gun, gunData) || bulletData.getExplosionData().isExplode())) {
                value.append(" + ").append(DAMAGE_FORMAT.format((double)bulletData.getExplosionData().getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get())).append((Component)Component.translatable((String)"tooltip.tacz.gun.explosion"));
            }
            this.damage = Component.translatable((String)"tooltip.tacz.gun.damage").append((Component)value);
            this.maxWidth = Math.max(font.width((FormattedText)this.damage), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            @Nullable ExtraDamage extraDamage = bulletData.getExtraDamage();
            if (extraDamage != null) {
                double armorDamagePercent = AttachmentDataUtils.getArmorIgnoreWithAttachment(this.gun, gunData);
                double headShotMultiplierPercent = AttachmentDataUtils.getHeadshotMultiplier(this.gun, gunData);
                armorDamagePercent = Mth.clamp((double)armorDamagePercent, (double)0.0, (double)1.0);
                this.armorIgnore = Component.translatable((String)"tooltip.tacz.gun.armor_ignore", (Object[])new Object[]{FORMAT.format(armorDamagePercent)});
                this.headShotMultiplier = Component.translatable((String)"tooltip.tacz.gun.head_shot_multiplier", (Object[])new Object[]{FORMAT.format(headShotMultiplierPercent)});
            } else {
                this.armorIgnore = Component.translatable((String)"tooltip.tacz.gun.armor_ignore", (Object[])new Object[]{FORMAT.format(0L)});
                this.headShotMultiplier = Component.translatable((String)"tooltip.tacz.gun.head_shot_multiplier", (Object[])new Object[]{FORMAT.format(1L)});
            }
            double weightFactor = (Double)SyncConfig.WEIGHT_SPEED_MULTIPLIER.get();
            double weight = AttachmentDataUtils.getWightWithAttachment(this.gun, gunData);
            this.weight = Component.translatable((String)"tooltip.tacz.gun.movement_speed", (Object[])new Object[]{FORMAT_P_D1.format(-weightFactor * weight)}).withStyle(ChatFormatting.RED);
            this.maxWidth = Math.max(font.width((FormattedText)this.armorIgnore), this.maxWidth);
            this.maxWidth = Math.max(font.width((FormattedText)this.headShotMultiplier), this.maxWidth);
            this.maxWidth = Math.max(font.width((FormattedText)this.weight), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            String keyName = Component.keybind((String)RefitKey.REFIT_KEY.getName()).getString().toUpperCase(Locale.ENGLISH);
            this.tips = Component.translatable((String)"tooltip.tacz.gun.tips", (Object[])new Object[]{keyName}).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC);
            this.maxWidth = Math.max(font.width((FormattedText)this.tips), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO) && (packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(gunId = this.iGun.getGunId(this.gun))) != null) {
            this.packInfo = Component.translatable((String)packInfoObject.getName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC);
            this.maxWidth = Math.max(font.width((FormattedText)this.packInfo), this.maxWidth);
        }
    }

    public void renderText(Font font, int pX, int pY, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int yOffset = pY;
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            yOffset += 2;
            for (FormattedCharSequence sequence : this.desc) {
                font.drawInBatch(sequence, (float)pX, (float)yOffset, 0xAAAAAA, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                yOffset += 10;
            }
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            font.drawInBatch(this.ammoName, (float)(pX + 20), (float)(yOffset += 4), 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.drawInBatch((Component)this.ammoCountText, (float)(pX + 20), (float)(yOffset + 10), 0x777777, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 20;
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            font.drawInBatch((Component)this.levelInfo, (float)pX, (float)(yOffset += 4), 0x777777, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
            if (this.gunType != null) {
                font.drawInBatch((Component)this.gunType, (float)pX, (float)yOffset, 0x777777, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                yOffset += 10;
            }
            font.drawInBatch((Component)this.damage, (float)pX, (float)yOffset, 0x777777, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            font.drawInBatch((Component)this.armorIgnore, (float)pX, (float)(yOffset += 4), 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.drawInBatch((Component)this.headShotMultiplier, (float)pX, (float)(yOffset += 10), 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.drawInBatch((Component)this.weight, (float)pX, (float)(yOffset += 10), 0xFFFFFF, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            font.drawInBatch((Component)this.tips, (float)pX, (float)(yOffset += 4), 0xFFFFFF, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO) && this.packInfo != null) {
            font.drawInBatch((Component)this.packInfo, (float)pX, (float)(yOffset += 4), 0xFFFFFF, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics guiGraphics) {
        IGun iGun = IGun.getIGunOrNull(this.gun);
        if (iGun == null) {
            return;
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            int yOffset = pY;
            if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
                yOffset += this.desc.size() * 10 + 2;
            }
            guiGraphics.renderItem(this.ammo, pX, yOffset + 4);
        }
    }

    private boolean shouldShow(GunTooltipPart part) {
        return (GunTooltipPart.getHideFlags(this.gun) & part.getMask()) == 0;
    }
}

