/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.inventory.tooltip.AmmoBoxTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ClientAmmoBoxTooltip
implements ClientTooltipComponent {
    private final ItemStack ammo;
    private final Component count;
    private final Component ammoName;

    public ClientAmmoBoxTooltip(AmmoBoxTooltip tooltip) {
        IAmmoBox box;
        this.ammo = tooltip.getAmmo();
        ItemStack ammoBox = tooltip.getAmmoBox();
        Item item = ammoBox.getItem();
        this.count = item instanceof IAmmoBox && (box = (IAmmoBox)item).isCreative(ammoBox) ? Component.literal((String)"\u221e") : Component.translatable((String)"tooltip.tacz.ammo_box.count", (Object[])new Object[]{tooltip.getCount()});
        this.ammoName = this.ammo.getHoverName();
    }

    public int getHeight() {
        return 28;
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.ammoName), font.width((FormattedText)this.count)) + 22;
    }

    public void renderText(Font font, int pX, int pY, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        font.drawInBatch(this.ammoName, (float)(pX + 20), (float)(pY + 4), 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(this.count, (float)(pX + 20), (float)(pY + 15), 0x666666, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        pGuiGraphics.renderItem(this.ammo, pX, pY + 5);
    }
}

