/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.client.animation.statemachine.ItemAnimationStateContext;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.util.math.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AnimateGeoItemRenderer<M extends BedrockAnimatedModel, CTX extends ItemAnimationStateContext>
extends BlockEntityWithoutLevelRenderer {
    @Nullable
    protected LuaAnimationStateMachine<CTX> stateMachine;
    protected M model;
    public ResourceLocation textureLocation;

    public AnimateGeoItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void setModel(M model) {
        this.model = model;
    }

    public M getModel(ItemStack stack) {
        return this.model;
    }

    @Nullable
    public LuaAnimationStateMachine<CTX> getStateMachine(ItemStack stack) {
        return this.stateMachine;
    }

    public ResourceLocation getTextureLocation(ItemStack stack) {
        return this.textureLocation;
    }

    public RenderType getRenderType(ItemStack stack) {
        return RenderType.entityCutout((ResourceLocation)this.getTextureLocation(stack));
    }

    public boolean needReInit(ItemStack stack) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return false;
        }
        return !stateMachine.isInitialized() && stateMachine.getExitingTime() < System.currentTimeMillis();
    }

    public abstract CTX initContext(ItemStack var1, Player var2, float var3);

    public abstract void updateContext(CTX var1, ItemStack var2, Player var3, float var4);

    public long getPutAwayTime(ItemStack stack) {
        return 0L;
    }

    public void tryInit(ItemStack stack, Player player, float partialTick) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        if (stateMachine.isInitialized()) {
            stateMachine.exit();
        }
        stateMachine.setContext(this.initContext(stack, player, partialTick));
        stateMachine.initialize();
        stateMachine.trigger("draw");
    }

    public void tryExit(ItemStack stack, long putAwayTime) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> context.setPutAwayTime((float)putAwayTime / 1000.0f));
        if (stateMachine.isInitialized()) {
            stateMachine.trigger("put_away");
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            stateMachine.setExitingTime(putAwayTime + 50L);
        }
    }

    public void triggerAnimation(ItemStack stack, String input) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.trigger(input);
    }

    public void visualUpdate(ItemStack stack) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.visualUpdate();
    }

    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, ItemStack stack, LocalPlayer player) {
        this.applyLevelCameraAnimation(event, stack, 1.0f);
    }

    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, ItemStack stack, float multiplier) {
        M model = this.getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf q = MathUtil.multiplyQuaternion(((BedrockAnimatedModel)model).getCameraAnimationObject().rotationQuaternion, multiplier);
        double yaw = Math.asin(2.0f * (q.w() * q.y() - q.x() * q.z()));
        double pitch = Math.atan2(2.0f * (q.w() * q.x() + q.y() * q.z()), 1.0f - 2.0f * (q.x() * q.x() + q.y() * q.y()));
        double roll = Math.atan2(2.0f * (q.w() * q.z() + q.x() * q.y()), 1.0f - 2.0f * (q.y() * q.y() + q.z() * q.z()));
        yaw = Math.toDegrees(yaw);
        pitch = Math.toDegrees(pitch);
        roll = Math.toDegrees(roll);
        event.setYaw((float)yaw + event.getYaw());
        event.setPitch((float)pitch + event.getPitch());
        event.setRoll((float)roll + event.getRoll());
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, ItemStack stack, LocalPlayer player) {
        this.applyItemInHandCameraAnimation(event, stack, 1.0f);
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, ItemStack stack, float multiplier) {
        M model = this.getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf quaternion = MathUtil.multiplyQuaternion(((BedrockAnimatedModel)model).getCameraAnimationObject().rotationQuaternion, multiplier);
        PoseStack poseStack = event.getPoseStack();
        poseStack.mulPose(quaternion);
    }

    public void doExtraTransforms(PoseStack poseStack, M model, ItemStack stack) {
        AnimateGeoItemRenderer.applyFirstPersonPositioningTransform(poseStack, model, stack);
    }

    public void renderFirstPerson(LocalPlayer player, ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource bufferSource, int light, float partialTick) {
        M model = this.getModel(stack);
        if (model != null) {
            poseStack.pushPose();
            float xRotOffset = Mth.lerp((float)partialTick, (float)player.xBobO, (float)player.xBob);
            float yRotOffset = Mth.lerp((float)partialTick, (float)player.yBobO, (float)player.yBob);
            float xRot = player.getViewXRot(partialTick) - xRotOffset;
            float yRot = player.getViewYRot(partialTick) - yRotOffset;
            poseStack.mulPose(Axis.XP.rotationDegrees(xRot * -0.1f));
            poseStack.mulPose(Axis.YP.rotationDegrees(yRot * -0.1f));
            BedrockPart rootNode = ((BedrockAnimatedModel)model).getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(yRot * 0.05f));
            }
            poseStack.translate(0.0f, 1.5f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            this.doExtraTransforms(poseStack, model, stack);
            LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
            if (stateMachine != null) {
                stateMachine.processContextIfExist(context -> this.updateContext(context, stack, (Player)player, partialTick));
                stateMachine.update();
            }
            ((BedrockModel)model).render(poseStack, ctx, this.getRenderType(stack), light, OverlayTexture.NO_OVERLAY);
            ((BedrockAnimatedModel)model).cleanAnimationTransform();
            poseStack.popPose();
        }
    }

    @ParametersAreNonnullByDefault
    public void renderByItem(ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (ctx.firstPerson()) {
            return;
        }
        M model = this.getModel(stack);
        if (model != null) {
            poseStack.pushPose();
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            ((BedrockModel)model).render(poseStack, ctx, RenderType.entityCutout((ResourceLocation)this.getTextureLocation(stack)), light, overlay);
            poseStack.popPose();
        }
    }

    @Nonnull
    public static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; --i) {
                BedrockPart part = nodePath.get(i);
                matrix4f.rotate((Quaternionfc)Axis.XN.rotation(part.xRot));
                matrix4f.rotate((Quaternionfc)Axis.YN.rotation(part.yRot));
                matrix4f.rotate((Quaternionfc)Axis.ZN.rotation(part.zRot));
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
                    continue;
                }
                matrix4f.translate(-part.x / 16.0f, 1.5f - part.y / 16.0f, -part.z / 16.0f);
            }
        }
        return matrix4f;
    }

    public static void applyFirstPersonPositioningTransform(PoseStack poseStack, BedrockAnimatedModel model, ItemStack stack) {
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        List<BedrockPart> idleNodePath = model.getIdleSightPath();
        Matrix4f idleViewMatrix = AnimateGeoItemRenderer.getPositioningNodeInverse(idleNodePath);
        MathUtil.applyMatrixLerp(transformMatrix, idleViewMatrix, transformMatrix, 1.0f);
        poseStack.translate(0.0f, 1.5f, 0.0f);
        poseStack.mulPose(transformMatrix);
        poseStack.translate(0.0f, -1.5f, 0.0f);
    }
}

