/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.renderer.item.GunItemRendererWrapper;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityBulletRenderer
extends EntityRenderer<EntityKineticBullet> {
    public EntityBulletRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
    }

    public void render(EntityKineticBullet bullet, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ResourceLocation gunId = bullet.getGunId();
        ResourceLocation gunDisplayId = bullet.getGunDisplayId();
        Optional<GunDisplayInstance> display = TimelessAPI.getGunDisplay(gunDisplayId, gunId);
        if (display.isEmpty()) {
            return;
        }
        float @Nullable [] tracerColor = bullet.getTracerColorOverride().orElse(display.get().getTracerColor());
        ResourceLocation ammoId = bullet.getAmmoId();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
            BedrockAmmoModel ammoEntityModel = ammoIndex.getAmmoEntityModel();
            ResourceLocation textureLocation = ammoIndex.getAmmoEntityTextureLocation();
            if (ammoEntityModel != null && textureLocation != null) {
                poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)bullet.yRotO, (float)bullet.getYRot()) - 180.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)bullet.xRotO, (float)bullet.getXRot())));
                poseStack.pushPose();
                poseStack.translate(0.0, 1.5, 0.0);
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                ammoEntityModel.render(poseStack, ItemDisplayContext.GROUND, RenderType.entityTranslucentCull((ResourceLocation)textureLocation), packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            if (bullet.isTracerAmmo()) {
                float[] actualTracerColor = Objects.requireNonNullElse(tracerColor, ammoIndex.getTracerColor());
                this.renderTracerAmmo(bullet, actualTracerColor, partialTicks, poseStack, packedLight);
            }
        });
    }

    public void renderTracerAmmo(EntityKineticBullet bullet, float[] tracerColor, float partialTicks, PoseStack poseStack, int packedLight) {
        EntityBulletRenderer.getModel().ifPresent(model -> {
            boolean isFirstPerson;
            Entity shooter = bullet.getOwner();
            if (shooter == null) {
                return;
            }
            boolean bl = isFirstPerson = this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && shooter instanceof LocalPlayer;
            if (isFirstPerson && !((Boolean)RenderConfig.FIRST_PERSON_BULLET_TRACER_ENABLE.get()).booleanValue()) {
                return;
            }
            poseStack.pushPose();
            float width = 0.005f;
            Vec3 bulletPosition = bullet.getPosition(partialTicks);
            double trailLength = 0.85 * bullet.getDeltaMovement().length();
            double disToEye = bulletPosition.distanceTo(shooter.getEyePosition(partialTicks));
            trailLength = Math.min(trailLength, disToEye * 0.8);
            if (isFirstPerson) {
                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                Vector3f offset = bullet.getFirstPersonRenderOffset();
                if (offset == null) {
                    offset = new Vector3f((Vector3fc)GunItemRendererWrapper.muzzleRenderOffset);
                    bullet.setCameraXRot(camera.getXRot());
                    bullet.setCameraYRot(camera.getYRot());
                    bullet.setFirstPersonRenderOffset(offset);
                }
                double offsetReducer = Math.max(0.0, 50.0 - disToEye) / 50.0;
                poseStack.mulPose(Axis.YN.rotationDegrees(bullet.getCameraYRot() + 180.0f));
                poseStack.mulPose(Axis.XN.rotationDegrees(bullet.getCameraXRot()));
                poseStack.translate((double)offset.x * offsetReducer, (double)offset.y * offsetReducer, (double)offset.z * offsetReducer);
                poseStack.mulPose(Axis.XP.rotationDegrees(bullet.getCameraXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(bullet.getCameraYRot() + 180.0f));
            }
            width *= bullet.getTracerSizeOverride();
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)bullet.yRotO, (float)bullet.getYRot()) - 180.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)bullet.xRotO, (float)bullet.getXRot())));
            poseStack.translate(0.0, isFirstPerson ? 0.0 : -0.2, trailLength / 2.0);
            poseStack.scale(width *= (float)Math.max(1.0, disToEye / 3.5), width, (float)trailLength);
            double bulletDistance = bulletPosition.distanceTo(shooter.getEyePosition());
            if (bullet.tickCount >= 5 || bulletDistance > 2.0) {
                RenderType type = RenderType.energySwirl((ResourceLocation)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                model.render(poseStack, ItemDisplayContext.NONE, type, packedLight, OverlayTexture.NO_OVERLAY, tracerColor[0], tracerColor[1], tracerColor[2], 1.0f);
            }
            poseStack.popPose();
        });
    }

    protected int getBlockLightLevel(@NotNull EntityKineticBullet entityBullet, @NotNull BlockPos blockPos) {
        return 15;
    }

    public boolean shouldRender(EntityKineticBullet bullet, Frustum camera, double pCamX, double pCamY, double pCamZ) {
        AABB aabb = bullet.getBoundingBoxForCulling().inflate(0.5);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(bullet.getX() - 2.0, bullet.getY() - 2.0, bullet.getZ() - 2.0, bullet.getX() + 2.0, bullet.getY() + 2.0, bullet.getZ() + 2.0);
        }
        return camera.isVisible(aabb);
    }

    public ResourceLocation getTextureLocation(@NotNull EntityKineticBullet entity) {
        return null;
    }
}

