/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.block.entity.StatueBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StatueRenderer
implements BlockEntityRenderer<StatueBlockEntity> {
    public StatueRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.STATUE_MODEL_LOCATION);
    }

    public void render(StatueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        StatueRenderer.getModel().ifPresent(model -> {
            Level level = blockEntity.getLevel();
            if (level == null) {
                return;
            }
            poseStack.pushPose();
            BlockState blockState = blockEntity.getBlockState();
            Direction facing = (Direction)blockState.getValue((Property)TargetBlock.FACING);
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees((float)((facing.get2DDataValue() + 2) % 4 * 90)));
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            RenderType renderType = RenderType.entityTranslucent((ResourceLocation)StatueRenderer.getTextureLocation());
            model.render(poseStack, ItemDisplayContext.NONE, renderType, combinedLightIn, combinedOverlayIn);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0, -0.875, -1.2);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            double offset = Math.sin((double)Util.getMillis() / 500.0) * 0.1;
            poseStack.translate(0.0, offset, 0.0);
            ItemStack stack = blockEntity.getGunItem();
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY, poseStack, bufferIn, level, 0);
            poseStack.popPose();
        });
    }

    public static ResourceLocation getTextureLocation() {
        return InternalAssetLoader.STATUE_TEXTURE_LOCATION;
    }

    public int getViewDistance() {
        return (Integer)RenderConfig.TARGET_RENDER_DISTANCE.get();
    }

    public boolean shouldRenderOffScreen(StatueBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(StatueBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.atCenterOf((Vec3i)pBlockEntity.getBlockPos().above()).closerThan((Position)pCameraPos, (double)this.getViewDistance());
    }
}

