/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.particles.BulletHoleOption;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BulletHoleParticle
extends TextureSheetParticle {
    private final Direction direction;
    private final BlockPos pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(ClientLevel world, double x, double y, double z, Direction direction, BlockPos pos, String ammoId, String gunId, String gunDisplayId) {
        super(world, x, y, z);
        this.setSprite(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.lifetime = this.getLifetimeFromConfig(world);
        this.hasPhysics = false;
        this.gravity = 0.0f;
        this.quadSize = 0.05f;
        BlockState state = world.getBlockState(pos);
        if (state.is((Block)ModBlocks.TARGET.get()) || this.shouldRemove()) {
            this.remove();
        }
        TimelessAPI.getGunDisplay(ResourceLocation.parse((String)gunDisplayId), ResourceLocation.parse((String)gunId)).ifPresent(gunIndex -> {
            float[] gunTracerColor = gunIndex.getTracerColor();
            if (gunTracerColor != null) {
                this.rCol = gunTracerColor[0];
                this.gCol = gunTracerColor[1];
                this.bCol = gunTracerColor[2];
            } else {
                TimelessAPI.getClientAmmoIndex(ResourceLocation.parse((String)ammoId)).ifPresent(ammoIndex -> {
                    float[] ammoTracerColor = ammoIndex.getTracerColor();
                    this.rCol = ammoTracerColor[0];
                    this.gCol = ammoTracerColor[1];
                    this.bCol = ammoTracerColor[2];
                });
            }
        });
        this.alpha = 0.9f;
    }

    private int getLifetimeFromConfig(ClientLevel world) {
        int configLife = (Integer)RenderConfig.BULLET_HOLE_PARTICLE_LIFE.get();
        if (configLife <= 1) {
            return configLife;
        }
        return configLife + world.random.nextInt(configLife / 2);
    }

    protected void setSprite(TextureAtlasSprite sprite) {
        super.setSprite(sprite);
        this.uOffset = this.random.nextInt(16);
        this.vOffset = this.random.nextInt(16);
        this.textureDensity = (sprite.getU1() - sprite.getU0()) / 16.0f;
    }

    private TextureAtlasSprite getSprite(BlockPos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel world = minecraft.level;
        if (world != null) {
            BlockState state = world.getBlockState(pos);
            return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getTexture(state, (Level)world, pos);
        }
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
    }

    protected float getU0() {
        return this.sprite.getU0() + (float)this.uOffset * this.textureDensity;
    }

    protected float getV0() {
        return this.sprite.getV0() + (float)this.vOffset * this.textureDensity;
    }

    protected float getU1() {
        return this.getU0() + this.textureDensity;
    }

    protected float getV1() {
        return this.getV0() + this.textureDensity;
    }

    public void tick() {
        super.tick();
        if (this.shouldRemove()) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 view = renderInfo.getPosition();
        float particleX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - view.x());
        float particleY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - view.y());
        float particleZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - view.z());
        Quaternionf quaternion = this.direction.getRotation();
        Vector3f[] points = new Vector3f[]{new Vector3f(-1.0f, 0.01f, -1.0f), new Vector3f(-1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, -1.0f)};
        float scale = this.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(scale);
            vector3f.add(particleX, particleY, particleZ);
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = Math.max(15 - this.age / 2, 0);
        int lightColor = LightTexture.pack((int)light, (int)light);
        float colorPercent = (float)light / 15.0f;
        float red = this.rCol * colorPercent;
        float green = this.gCol * colorPercent;
        float blue = this.bCol * colorPercent;
        double threshold = (Double)RenderConfig.BULLET_HOLE_PARTICLE_FADE_THRESHOLD.get() * (double)this.lifetime;
        float fade = 1.0f - (float)(Math.max((double)this.age - threshold, 0.0) / ((double)this.lifetime - threshold));
        float alphaFade = this.alpha * fade;
        buffer.addVertex(points[0].x(), points[0].y(), points[0].z()).setUv(u1, v1).setColor(red, green, blue, alphaFade).setLight(lightColor);
        buffer.addVertex(points[1].x(), points[1].y(), points[1].z()).setUv(u1, v0).setColor(red, green, blue, alphaFade).setLight(lightColor);
        buffer.addVertex(points[2].x(), points[2].y(), points[2].z()).setUv(u0, v0).setColor(red, green, blue, alphaFade).setLight(lightColor);
        buffer.addVertex(points[3].x(), points[3].y(), points[3].z()).setUv(u0, v1).setColor(red, green, blue, alphaFade).setLight(lightColor);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    private boolean shouldRemove() {
        BlockState blockState = this.level.getBlockState(this.pos);
        if (blockState.isAir()) {
            return true;
        }
        VoxelShape shape = blockState.getCollisionShape((BlockGetter)this.level, this.pos);
        if (shape.isEmpty()) {
            return true;
        }
        AABB baseBlockBoundingBox = shape.bounds();
        AABB blockBoundingBox = baseBlockBoundingBox.move(this.pos);
        boolean intersects = blockBoundingBox.intersects(this.x - 0.1, this.y - 0.1, this.z - 0.1, this.x + 0.1, this.y + 0.1, this.z + 0.1);
        return !intersects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<BulletHoleOption> {
        public BulletHoleParticle createParticle(@NotNull BulletHoleOption option, @NotNull ClientLevel world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
            BulletHoleParticle particle = new BulletHoleParticle(world, x, y, z, option.getDirection(), option.getPos(), option.getAmmoId(), option.getGunId(), option.getGunDisplayId());
            return particle;
        }
    }
}

