/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.display.gun.MuzzleFlash;
import com.tacz.guns.compat.iris.IrisCompat;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MuzzleFlashRender
implements IFunctionalRenderer {
    private static final SlotModel MUZZLE_FLASH_MODEL = new SlotModel(true);
    private static final long TIME_RANGE = 50L;
    public static boolean isSelf = false;
    private static long shootTimeStamp = -1L;
    private static boolean muzzleFlashStartMark = false;
    private static float muzzleFlashRandomRotate = 0.0f;
    private static Matrix3f muzzleFlashNormal = new Matrix3f();
    private static Matrix4f muzzleFlashPose = new Matrix4f();
    private final BedrockGunModel bedrockGunModel;

    public MuzzleFlashRender(BedrockGunModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    public static void onShoot() {
        shootTimeStamp = System.currentTimeMillis();
        muzzleFlashStartMark = true;
        muzzleFlashRandomRotate = (float)(Math.random() * 360.0);
    }

    private static void renderMuzzleFlash(GunDisplayInstance display, PoseStack poseStack, BedrockModel bedrockModel, long time) {
        MuzzleFlash muzzleFlash = display.getMuzzleFlash();
        if (muzzleFlash == null) {
            return;
        }
        if (muzzleFlashStartMark) {
            muzzleFlashNormal = new Matrix3f((Matrix3fc)poseStack.last().normal());
            muzzleFlashPose = new Matrix4f((Matrix4fc)poseStack.last().pose());
        }
        bedrockModel.delegateRender((poseStack1, vertexConsumer1, transformType1, light, overlay) -> MuzzleFlashRender.doRender(light, overlay, muzzleFlash, time));
    }

    private static void doRender(int light, int overlay, MuzzleFlash muzzleFlash, long time) {
        if (muzzleFlashNormal != null && muzzleFlashPose != null) {
            float scale = 0.5f * muzzleFlash.getScale();
            float scaleTime = 25.0f;
            scale = (float)time < scaleTime ? scale * ((float)time / scaleTime) : scale;
            muzzleFlashStartMark = false;
            MultiBufferSource.BufferSource multiBufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            PoseStack poseStack2 = new PoseStack();
            poseStack2.last().normal().mul((Matrix3fc)muzzleFlashNormal);
            poseStack2.last().pose().mul((Matrix4fc)muzzleFlashPose);
            poseStack2.pushPose();
            poseStack2.scale(scale, scale, scale);
            poseStack2.mulPose(Axis.ZP.rotationDegrees(muzzleFlashRandomRotate));
            poseStack2.translate(0.0f, -1.0f, 0.0f);
            RenderType renderTypeBg = RenderType.entityTranslucent((ResourceLocation)muzzleFlash.getTexture());
            MUZZLE_FLASH_MODEL.renderToBuffer(poseStack2, multiBufferSource.getBuffer(renderTypeBg), light, overlay);
            poseStack2.popPose();
            poseStack2.pushPose();
            poseStack2.scale(scale / 2.0f, scale / 2.0f, scale / 2.0f);
            poseStack2.mulPose(Axis.ZP.rotationDegrees(muzzleFlashRandomRotate));
            poseStack2.translate(0.0, -0.9, 0.0);
            RenderType renderTypeLight = RenderType.energySwirl((ResourceLocation)muzzleFlash.getTexture(), (float)1.0f, (float)1.0f);
            MUZZLE_FLASH_MODEL.renderToBuffer(poseStack2, multiBufferSource.getBuffer(renderTypeLight), light, overlay);
            poseStack2.popPose();
        }
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        if (IrisCompat.isRenderShadow()) {
            return;
        }
        if (!isSelf) {
            return;
        }
        long time = System.currentTimeMillis() - shootTimeStamp;
        if (time > 50L) {
            return;
        }
        ItemStack currentGunItem = this.bedrockGunModel.getCurrentGunItem();
        TimelessAPI.getGunDisplay(currentGunItem).ifPresent(display -> {
            ItemStack muzzleAttachment = this.bedrockGunModel.getCurrentAttachmentItem().get((Object)AttachmentType.MUZZLE);
            IAttachment iAttachment = IAttachment.getIAttachmentOrNull(muzzleAttachment);
            if (iAttachment != null) {
                ResourceLocation attachmentId = iAttachment.getAttachmentId(muzzleAttachment);
                TimelessAPI.getCommonAttachmentIndex(attachmentId).ifPresent(index -> {
                    Pair pair;
                    Object patt0$temp;
                    Map<String, JsonProperty<?>> modifier = index.getData().getModifier();
                    if (modifier.containsKey(SilenceModifier.ID) && (patt0$temp = modifier.get(SilenceModifier.ID).getValue()) instanceof Pair && ((Boolean)(pair = (Pair)patt0$temp).right()).booleanValue()) {
                        return;
                    }
                    MuzzleFlashRender.renderMuzzleFlash(display, poseStack, this.bedrockGunModel, time);
                });
            } else {
                MuzzleFlashRender.renderMuzzleFlash(display, poseStack, this.bedrockGunModel, time);
            }
        });
    }
}

