/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.client.KeyConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.util.InputExtraCheck;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@EventBusSubscriber(value={Dist.CLIENT})
public class CrawlKey {
    public static final KeyMapping CRAWL_KEY = new KeyMapping("key.tacz.crawl.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 67, "key.category.tacz");

    @SubscribeEvent
    public static void onCrawlPress(InputEvent.Key event) {
        if (InputExtraCheck.isInGame() && CRAWL_KEY.matches(event.getKey(), event.getScanCode())) {
            if (!((Boolean)SyncConfig.ENABLE_CRAWL.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.isSpectator() || player.isPassenger()) {
                return;
            }
            if (!(player instanceof IClientPlayerGunOperator)) {
                return;
            }
            IClientPlayerGunOperator operator = (IClientPlayerGunOperator)player;
            Item item = player.getMainHandItem().getItem();
            if (item instanceof IGun) {
                IGun iGun = (IGun)item;
                if (!iGun.isCanCrawl(player.getMainHandItem())) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
                    return;
                }
                boolean action = true;
                if (!((Boolean)KeyConfig.HOLD_TO_CRAWL.get()).booleanValue()) {
                    boolean bl = action = !operator.isCrawl();
                }
                if (event.getAction() == 1) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(action);
                }
                if (((Boolean)KeyConfig.HOLD_TO_CRAWL.get()).booleanValue() && event.getAction() == 0) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
                }
            }
        }
    }

    public static boolean onCrawlControllerPress(boolean isPress) {
        if (!InputExtraCheck.isInGame()) {
            return false;
        }
        if (!((Boolean)SyncConfig.ENABLE_CRAWL.get()).booleanValue()) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator() || player.isPassenger()) {
            return false;
        }
        if (!(player instanceof IClientPlayerGunOperator)) {
            return false;
        }
        IClientPlayerGunOperator operator = (IClientPlayerGunOperator)player;
        if (!IGun.mainHandHoldGun((LivingEntity)player)) {
            return false;
        }
        boolean action = true;
        if (!((Boolean)KeyConfig.HOLD_TO_CRAWL.get()).booleanValue()) {
            boolean bl = action = !operator.isCrawl();
        }
        if (isPress) {
            IClientPlayerGunOperator.fromLocalPlayer(player).crawl(action);
            return true;
        }
        if (((Boolean)KeyConfig.HOLD_TO_CRAWL.get()).booleanValue()) {
            IClientPlayerGunOperator.fromLocalPlayer(player).crawl(false);
            return true;
        }
        return false;
    }
}

