/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.tacz.guns.compat.cloth.MenuIntegration;
import com.tacz.guns.init.CompatRegistry;
import com.tacz.guns.util.InputExtraCheck;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@EventBusSubscriber(value={Dist.CLIENT})
public class ConfigKey {
    public static final KeyMapping OPEN_CONFIG_KEY = new KeyMapping("key.tacz.open_config.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 84, "key.category.tacz");

    @SubscribeEvent
    public static void onOpenConfig(InputEvent.Key event) {
        if (InputExtraCheck.isInGame() && event.getAction() == 1 && OPEN_CONFIG_KEY.matches(event.getKey(), event.getScanCode()) && OPEN_CONFIG_KEY.getKeyModifier().isActive(OPEN_CONFIG_KEY.getKeyConflictContext())) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.isSpectator()) {
                return;
            }
            if (!ModList.get().isLoaded("cloth_config")) {
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/cloth-config");
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"gui.tacz.cloth_config_warning.download"));
                MutableComponent component = Component.translatable((String)"gui.tacz.cloth_config_warning.tips").withStyle(style -> style.applyFormat(ChatFormatting.BLUE).applyFormat(ChatFormatting.UNDERLINE).withClickEvent(clickEvent).withHoverEvent(hoverEvent));
                player.sendSystemMessage((Component)component);
            } else {
                CompatRegistry.checkModLoad("cloth_config", () -> Minecraft.getInstance().setScreen(MenuIntegration.getConfigScreen(null)));
            }
        }
    }
}

