/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.client.RenderConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class KillAmountOverlay
implements LayeredDraw.Layer {
    private static long killTimestamp = -1L;
    private static int killAmount = 0;

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        if (!((Boolean)RenderConfig.KILL_AMOUNT_ENABLE.get()).booleanValue()) {
            return;
        }
        int timeout = (int)((Double)RenderConfig.KILL_AMOUNT_DURATION_SECOND.get() * 1000.0);
        float colorCount = 30.0f;
        long remainTime = System.currentTimeMillis() - killTimestamp;
        if (remainTime > (long)timeout) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof IGun)) {
            return;
        }
        String text = killAmount < 10 ? "\u2620 x 0" + killAmount : "\u2620 x " + killAmount;
        int fontWith = mc.font.width(text);
        double fadeOutTime = (double)timeout / 3.0 * 2.0;
        float hue = (1.0f - Math.min((float)killAmount / colorCount, 1.0f)) * 0.15f;
        int alpha = 255;
        if ((double)remainTime > fadeOutTime) {
            alpha = 255 - (int)(((double)remainTime - fadeOutTime) / ((double)timeout - fadeOutTime) * 240.0);
        }
        int color = Mth.hsvToRgb((float)hue, (float)0.75f, (float)1.0f) + (alpha << 24);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 1.0f);
        graphics.drawString(mc.font, text, (int)((float)width - (float)fontWith / 2.0f), (height - 45) * 2 - 1, color);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    public static void markTimestamp() {
        int timeout = (int)((Double)RenderConfig.KILL_AMOUNT_DURATION_SECOND.get() * 1000.0);
        if (System.currentTimeMillis() - killTimestamp > (long)timeout) {
            killAmount = 0;
        }
        killTimestamp = System.currentTimeMillis();
        ++killAmount;
    }
}

