/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.input.InteractKey;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.util.InteractKeyConfigRead;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.StringUtils;

public class InteractKeyTextOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics graphics, DeltaTracker delta) {
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        if (((Boolean)RenderConfig.DISABLE_INTERACT_HUD_TEXT.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.isSpectator()) {
            return;
        }
        if (!IGun.mainHandHoldGun((LivingEntity)player)) {
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult == null) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            InteractKeyTextOverlay.renderBlockText(graphics, width, height, blockHitResult, player, mc);
            return;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            InteractKeyTextOverlay.renderEntityText(graphics, width, height, entityHitResult, mc);
        }
    }

    private static void renderBlockText(GuiGraphics graphics, int width, int height, BlockHitResult blockHitResult, LocalPlayer player, Minecraft mc) {
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockState block = player.level().getBlockState(blockPos);
        if (InteractKeyConfigRead.canInteractBlock(block)) {
            InteractKeyTextOverlay.renderText(graphics, width, height, mc.font);
        }
    }

    private static void renderEntityText(GuiGraphics graphics, int width, int height, EntityHitResult entityHitResult, Minecraft mc) {
        Entity entity = entityHitResult.getEntity();
        if (InteractKeyConfigRead.canInteractEntity(entity)) {
            InteractKeyTextOverlay.renderText(graphics, width, height, mc.font);
        }
    }

    private static void renderText(GuiGraphics graphics, int width, int height, Font font) {
        String keyName = InteractKey.INTERACT_KEY.getTranslatedKeyMessage().getString();
        MutableComponent title = Component.translatable((String)"gui.tacz.interact_key.text.desc", (Object[])new Object[]{StringUtils.capitalize((String)keyName)});
        graphics.drawString(font, (Component)title, (int)((float)(width - font.width((FormattedText)title)) / 2.0f), (int)((float)height / 2.0f - 25.0f), ChatFormatting.YELLOW.getColor().intValue(), false);
    }
}

