/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.smith;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ResultButton
extends Button {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/gui/gun_smith_table.png");
    private final ItemStack stack;
    private boolean isSelected = false;

    public ResultButton(int pX, int pY, ItemStack stack, Button.OnPress onPress) {
        super(pX, pY, 94, 16, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.stack = stack;
    }

    protected void renderWidget(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.enableDepthTest();
        if (this.isSelected) {
            if (this.isHoveredOrFocused()) {
                gui.blit(TEXTURE, this.getX() - 1, this.getY() - 1, 52.0f, 229.0f, this.width + 2, this.height + 2, 256, 256);
            } else {
                gui.blit(TEXTURE, this.getX(), this.getY(), 53.0f, 230.0f, this.width, this.height, 256, 256);
            }
        } else if (this.isHoveredOrFocused()) {
            gui.blit(TEXTURE, this.getX() - 1, this.getY() - 1, 52.0f, 211.0f, this.width + 2, this.height + 2, 256, 256);
        } else {
            gui.blit(TEXTURE, this.getX(), this.getY(), 53.0f, 212.0f, this.width, this.height, 256, 256);
        }
        Minecraft mc = Minecraft.getInstance();
        gui.renderItem(this.stack, this.getX() + 1, this.getY());
        Component hoverName = this.stack.getHoverName();
        ResultButton.renderScrollingString((GuiGraphics)gui, (Font)mc.font, (Component)hoverName, (int)(this.getX() + 20), (int)(this.getY() + 4), (int)(this.getX() + 92), (int)(this.getY() + 13), (int)0xFFFFFF);
    }

    public void onPress() {
        this.isSelected = true;
        this.onPress.onPress((Button)this);
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void renderTooltips(Consumer<ItemStack> consumer) {
        if (this.isHoveredOrFocused() && !this.stack.isEmpty()) {
            consumer.accept(this.stack);
        }
    }
}

