/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.gui.components.refit.IStackTooltip;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GunAttachmentSlot
extends Button
implements IStackTooltip {
    private final AttachmentType type;
    private final Inventory inventory;
    private final int gunItemIndex;
    private final String nameKey;
    private boolean selected = false;
    private ItemStack attachmentItem = ItemStack.EMPTY;

    public GunAttachmentSlot(int pX, int pY, AttachmentType type, int gunItemIndex, Inventory inventory, Button.OnPress onPress) {
        super(pX, pY, 18, 18, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.type = type;
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.nameKey = String.format("tooltip.tacz.attachment.%s", type.name().toLowerCase(Locale.US));
    }

    @Override
    public void renderTooltip(Consumer<ItemStack> consumer) {
        if (this.isHoveredOrFocused() && !this.attachmentItem.isEmpty()) {
            consumer.accept(this.attachmentItem);
        }
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack gunItem;
        IGun iGun;
        if (this.isHoveredOrFocused()) {
            Font font = Minecraft.getInstance().font;
            int yOffset = this.getY() + 20;
            if (this.selected && !this.attachmentItem.isEmpty()) {
                yOffset = this.getY() + 30;
            }
            graphics.drawCenteredString(font, (Component)Component.translatable((String)this.nameKey), this.getX() + this.getWidth() / 2, yOffset, ChatFormatting.WHITE.getColor().intValue());
        }
        if ((iGun = IGun.getIGunOrNull(gunItem = this.inventory.getItem(this.gunItemIndex))) == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        int x = this.getX();
        int y = this.getY();
        if (this.isHoveredOrFocused() || this.selected) {
            graphics.blit(GunRefitScreen.SLOT_TEXTURE, x, y, 0.0f, 0.0f, this.width, this.height, 18, 18);
        } else {
            graphics.blit(GunRefitScreen.SLOT_TEXTURE, x + 1, y + 1, 1.0f, 1.0f, this.width - 2, this.height - 2, 18, 18);
        }
        this.attachmentItem = iGun.getAttachment((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), gunItem, this.type);
        if (!this.attachmentItem.isEmpty()) {
            graphics.renderItem(this.attachmentItem, x + 1, y + 1);
        } else {
            int xOffset = GunRefitScreen.getSlotTextureXOffset(gunItem, this.type);
            graphics.blit(GunRefitScreen.ICONS_TEXTURE, x + 2, y + 2, this.width - 4, this.height - 4, (float)xOffset, 0.0f, 32, 32, GunRefitScreen.getSlotsTextureWidth(), 32);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public ItemStack getAttachmentItem() {
        ItemStack gunItem = this.inventory.getItem(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return ItemStack.EMPTY;
        }
        return iGun.getAttachment((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), gunItem, this.type);
    }

    public boolean isAllow() {
        ItemStack gunItem = this.inventory.getItem(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return false;
        }
        return iGun.allowAttachmentType(gunItem, this.type);
    }
}

