/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.client.gui.GunSmithTableScreen;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GunPackList
extends ContainerObjectSelectionList<Entry> {
    private final GunSmithTableScreen parent;
    private final List<Checkbox> gunPackList = new ArrayList<Checkbox>();
    private final Set<String> selectedNamespaces = new HashSet<String>();
    private final Checkbox byHandCheckbox;
    private final EditBox byName;

    public GunPackList(Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pY1, int pItemHeight, Map<ResourceLocation, List<ResourceLocation>> recipes, final GunSmithTableScreen parent) {
        super(pMinecraft, pWidth, pHeight, pY0, pItemHeight);
        this.parent = parent;
        HashSet namespaces = new HashSet();
        for (List<ResourceLocation> entry : recipes.values()) {
            entry.forEach(resourceLocation -> namespaces.add(resourceLocation.getNamespace()));
        }
        this.byName = new EditBox(pMinecraft.font, 3, 0, 94, 10, (Component)Component.empty());
        this.byName.setHint((Component)Component.translatable((String)"gui.tacz.gun_smith_table.filter.search"));
        this.byName.setResponder(pText -> {
            parent.init();
            parent.setIndexPage(0);
        });
        this.addEntry((AbstractSelectionList.Entry)new Entry((AbstractWidget)this.byName));
        this.byHandCheckbox = new Checkbox(this, 0, 0, 10, 10, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.filter.handgun"), false){

            @Override
            public void onPress() {
                super.onPress();
                parent.init();
                parent.setIndexPage(0);
            }
        };
        this.addEntry((AbstractSelectionList.Entry)new Entry((AbstractWidget)this.byHandCheckbox));
        final Checkbox checkbox1 = new Checkbox(0, 0, 10, 10, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.filter.all"), true){

            @Override
            public void onPress() {
                super.onPress();
                GunPackList.this.gunPackList.forEach(checkbox -> {
                    checkbox.selected = this.selected;
                });
                GunPackList.this.updateSelectedNamespaces();
            }
        };
        this.addEntry((AbstractSelectionList.Entry)new Entry((AbstractWidget)checkbox1));
        for (String namespace : namespaces) {
            PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(namespace);
            MutableComponent name = packInfo == null ? Component.literal((String)namespace) : Component.translatable((String)packInfo.getName());
            Checkbox checkbox = new Checkbox(0, 0, 10, 10, (Component)name, namespace, true){

                @Override
                public void onPress() {
                    super.onPress();
                    checkbox1.selected = GunPackList.this.gunPackList.stream().allMatch(Checkbox::selected);
                    GunPackList.this.updateSelectedNamespaces();
                }
            };
            this.gunPackList.add(checkbox);
            this.selectedNamespaces.add(namespace);
            this.addEntry((AbstractSelectionList.Entry)new Entry((AbstractWidget)checkbox));
        }
    }

    public String getSearchText() {
        return this.byName.getValue();
    }

    public boolean isByHandSelected() {
        return this.byHandCheckbox.selected;
    }

    public Set<String> namespaceList() {
        return this.selectedNamespaces;
    }

    public void updateSelectedNamespaces() {
        this.selectedNamespaces.clear();
        this.gunPackList.forEach(checkbox -> {
            if (checkbox.selected) {
                this.selectedNamespaces.add(checkbox.getId());
            }
        });
        this.parent.init();
        this.parent.setIndexPage(0);
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 2;
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderListBackground(pGuiGraphics);
        pGuiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), Integer.MIN_VALUE);
        int i = this.getScrollbarPosition();
        int j = i + 6;
        this.enableScissor(pGuiGraphics);
        this.renderListItems(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.disableScissor();
        this.renderListSeparators(pGuiGraphics);
        int i2 = this.getMaxScroll();
        if (i2 > 0) {
            int j2 = (int)((float)((this.getBottom() - this.getY()) * (this.getBottom() - this.getY())) / (float)this.getMaxPosition());
            j2 = Mth.clamp((int)j2, (int)32, (int)(this.getBottom() - this.getY() - 8));
            int k1 = (int)this.getScrollAmount() * (this.getBottom() - this.getY() - j2) / i2 + this.getY();
            if (k1 < this.getY()) {
                k1 = this.getY();
            }
            pGuiGraphics.fill(i, k1, j, k1 + j2, -8355712);
            pGuiGraphics.fill(i, k1, j - 1, k1 + j2 - 1, -4144960);
        }
        this.renderDecorations(pGuiGraphics, pMouseX, pMouseY);
        RenderSystem.disableBlend();
    }

    public int getRowLeft() {
        return this.getX() + 4;
    }

    public int getRowWidth() {
        return this.width;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final AbstractWidget widget;

        public Entry(AbstractWidget widget) {
            this.widget = widget;
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.widget);
        }

        public void render(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pHovering, float pPartialTick) {
            this.widget.setX(pLeft);
            this.widget.setY(pTop);
            this.widget.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.widget);
        }
    }

    public static class Checkbox
    extends AbstractButton {
        private static final ResourceLocation CHECKBOX = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/checkbox.png");
        private static final ResourceLocation CHECKBOX_HIGHLIGHTED = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/checkbox_highlighted.png");
        private static final ResourceLocation CHECKBOX_SELECTED = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/checkbox_selected.png");
        private static final ResourceLocation CHECKBOX_SELECTED_HIGHLIGHTED = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/checkbox_selected_highlighted.png");
        protected boolean selected;
        protected final boolean showLabel;
        private String id;

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, String id, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
            this.id = id;
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected, boolean pShowLabel) {
            super(pX, pY, pWidth, pHeight, pMessage);
            this.selected = pSelected;
            this.showLabel = pShowLabel;
        }

        public String getId() {
            return this.id;
        }

        public void onPress() {
            this.selected = !this.selected;
        }

        public boolean selected() {
            return this.selected;
        }

        public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            pNarrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
            if (this.active) {
                if (this.isFocused()) {
                    pNarrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
                } else {
                    pNarrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            RenderSystem.enableDepthTest();
            Font font = minecraft.font;
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            ResourceLocation texture = this.isFocused() ? (this.selected ? CHECKBOX_SELECTED_HIGHLIGHTED : CHECKBOX_HIGHLIGHTED) : (this.selected ? CHECKBOX_SELECTED : CHECKBOX);
            pGuiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 10, 10, 10, 10);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.showLabel) {
                pGuiGraphics.drawString(font, this.getMessage(), this.getX() + 24, this.getY() + (this.height - 8) / 2, 0xE0E0E0 | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
            }
        }
    }
}

