/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.compat;

import com.tacz.guns.GunMod;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ClothConfigScreen
extends Screen {
    public static final String CLOTH_CONFIG_URL = "https://www.curseforge.com/minecraft/mc-mods/cloth-config";
    private final Screen lastScreen;
    private MultiLineLabel message = MultiLineLabel.EMPTY;

    protected ClothConfigScreen(Screen lastScreen) {
        super((Component)Component.literal((String)"Cloth Config API"));
        this.lastScreen = lastScreen;
    }

    public static void registerNoClothConfigPage() {
        if (!ModList.get().isLoaded("cloth_config")) {
            GunMod.container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, screen) -> new ClothConfigScreen(screen)));
        }
    }

    protected void init() {
        int posX = (this.width - 200) / 2;
        int posY = this.height / 2;
        this.message = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"gui.tacz.cloth_config_warning.tips"), (int)300);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.tacz.cloth_config_warning.download"), b -> this.openUrl(CLOTH_CONFIG_URL)).bounds(posX, posY - 15, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, b -> Minecraft.getInstance().setScreen(this.lastScreen)).bounds(posX, posY + 50, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(gui, pMouseX, pMouseY, pPartialTick);
        this.message.renderCentered(gui, this.width / 2, 80);
        super.render(gui, pMouseX, pMouseY, pPartialTick);
    }

    private void openUrl(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ConfirmLinkScreen(yes -> {
                if (yes) {
                    Util.getPlatform().openUri(url);
                }
                this.minecraft.setScreen((Screen)this);
            }, url, true));
        }
    }
}

