/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gui.components.FlatColorButton;
import com.tacz.guns.client.gui.components.GunPackList;
import com.tacz.guns.client.gui.components.smith.ImageButton;
import com.tacz.guns.client.gui.components.smith.ResultButton;
import com.tacz.guns.client.gui.components.smith.TypeButton;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.inventory.GunSmithTableMenu;
import com.tacz.guns.network.message.ClientMessageCraft;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.util.RenderDistance;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class GunSmithTableScreen
extends AbstractContainerScreen<GunSmithTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/gui/gun_smith_table.png");
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/gui/gun_smith_table_side.png");
    private final LinkedHashMap<ResourceLocation, TabConfig> recipeKeys = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, List<ResourceLocation>> recipes = Maps.newLinkedHashMap();
    private int typePage;
    private ResourceLocation selectedType = null;
    private List<ResourceLocation> selectedRecipeList = new ArrayList<ResourceLocation>();
    private int indexPage;
    @Nullable
    private RecipeHolder<GunSmithTableRecipe> selectedRecipe;
    @Nullable
    private Int2IntArrayMap playerIngredientCount;
    private int scale = 70;
    private boolean filterEnabled = false;
    private GunPackList filterList;

    public GunSmithTableScreen(GunSmithTableMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 344;
        this.imageHeight = 186;
        this.classifyRecipes();
        this.typePage = 0;
        this.indexPage = 0;
        this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty() ? this.selectedRecipeList.get(0) : null);
        this.getPlayerIngredientCount(this.selectedRecipe);
    }

    public static void drawModCenteredString(GuiGraphics gui, Font font, Component component, int pX, int pY, int color) {
        FormattedCharSequence text = component.getVisualOrderText();
        gui.drawString(font, text, pX - font.width(text) / 2, pY, color, false);
    }

    private void classifyRecipes() {
        this.recipes.clear();
        this.recipeKeys.clear();
        ResourceLocation blockId = ((GunSmithTableMenu)this.menu).getBlockId();
        if (blockId == null) {
            return;
        }
        LinkedHashMap recipes = Maps.newLinkedHashMap();
        LinkedHashMap recipeKeys = Maps.newLinkedHashMap();
        TimelessAPI.getCommonBlockIndex(blockId).ifPresent(blockIndex -> {
            List<TabConfig> tabs = blockIndex.getData().getTabs();
            if (DefaultAssets.DEFAULT_BLOCK_ID.equals((Object)blockId) && !((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue()) {
                tabs = TabConfig.DEFAULT_TABS;
            }
            for (TabConfig tab : tabs) {
                recipes.put(tab.id(), Lists.newArrayList());
                recipeKeys.put(tab.id(), tab);
            }
        });
        ArrayList recipeIds = Lists.newArrayList();
        if (Minecraft.getInstance().level != null) {
            RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
            List recipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get());
            Set<String> namespaces = this.filterList != null ? this.filterList.namespaceList() : null;
            for (RecipeHolder holder : recipeList) {
                ResourceLocation groupName;
                GunSmithTableRecipe recipe = (GunSmithTableRecipe)holder.value();
                ResourceLocation id = holder.id();
                if (namespaces != null && !namespaces.contains(id.getNamespace()) || !this.isSuitableForMainHand(recipe) || !this.isNameMatch(recipe) || !recipeKeys.containsKey(groupName = recipe.getResult().getGroup())) continue;
                recipeIds.add(Pair.of((Object)groupName, (Object)id));
            }
        }
        TimelessAPI.getCommonBlockIndex(((GunSmithTableMenu)this.menu).getBlockId()).map(blockIndex -> {
            if (((GunSmithTableMenu)this.menu).getBlockId().equals((Object)DefaultAssets.DEFAULT_BLOCK_ID) && !((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue()) {
                return null;
            }
            RecipeFilter filter = blockIndex.getFilter();
            if (filter != null) {
                return filter.filter(recipeIds, Pair::value);
            }
            return null;
        }).orElse(recipeIds).forEach(entry -> {
            ResourceLocation groupName = (ResourceLocation)entry.key();
            if (recipeKeys.containsKey(groupName)) {
                recipes.computeIfAbsent(groupName, g -> Lists.newArrayList()).add((ResourceLocation)entry.value());
            }
        });
        for (Map.Entry entry2 : recipes.entrySet()) {
            if (((List)entry2.getValue()).isEmpty()) continue;
            this.recipes.put((ResourceLocation)entry2.getKey(), (List)entry2.getValue());
            this.recipeKeys.put((ResourceLocation)entry2.getKey(), (TabConfig)recipeKeys.get(entry2.getKey()));
        }
        if (!recipeKeys.containsKey(this.selectedType)) {
            this.selectedType = null;
            this.selectedRecipeList = null;
        }
        if (!this.recipeKeys.keySet().isEmpty() && this.selectedType == null) {
            this.selectedType = this.recipeKeys.keySet().iterator().next();
        }
        if (this.selectedType != null) {
            this.selectedRecipeList = this.recipes.get(this.selectedType);
        }
    }

    private boolean isNameMatch(GunSmithTableRecipe recipe) {
        if (this.filterList != null && StringUtils.isNotBlank((CharSequence)this.filterList.getSearchText())) {
            String searchText = this.filterList.getSearchText().toLowerCase();
            Component name = recipe.getResult().getResult().getHoverName();
            return name.getString().toLowerCase().contains(searchText);
        }
        return true;
    }

    private boolean isSuitableForMainHand(GunSmithTableRecipe recipe) {
        if (this.filterList != null && this.filterList.isByHandSelected()) {
            ItemStack result = recipe.getResult().getResult();
            Minecraft minecraft = Minecraft.getInstance();
            ItemStack stack = minecraft.player != null ? minecraft.player.getMainHandItem() : ItemStack.EMPTY;
            Item item = stack.getItem();
            if (item instanceof IGun) {
                IGun igun = (IGun)item;
                Item item2 = result.getItem();
                if (item2 instanceof IAmmo) {
                    IAmmo iAmmo = (IAmmo)item2;
                    return iAmmo.isAmmoOfGun(stack, result);
                }
                if (result.getItem() instanceof IAttachment) {
                    return igun.allowAttachment(stack, result);
                }
                return false;
            }
            if (stack.getItem() instanceof IAttachment) {
                item = result.getItem();
                if (item instanceof IGun) {
                    IGun iGun = (IGun)item;
                    return iGun.allowAttachment(result, stack);
                }
                return false;
            }
            item = stack.getItem();
            if (item instanceof IAmmo) {
                IAmmo iAmmo = (IAmmo)item;
                if (result.getItem() instanceof IGun) {
                    return iAmmo.isAmmoOfGun(result, stack);
                }
                return false;
            }
        }
        return true;
    }

    public void setIndexPage(int indexPage) {
        this.indexPage = indexPage;
    }

    @Nullable
    private RecipeHolder<GunSmithTableRecipe> getSelectedRecipe(ResourceLocation recipeId) {
        RecipeManager recipeManager;
        RecipeHolder holder;
        if (Minecraft.getInstance().level != null && (holder = (RecipeHolder)(recipeManager = Minecraft.getInstance().level.getRecipeManager()).byKey(recipeId).orElse(null)) != null && holder.value() instanceof GunSmithTableRecipe) {
            return holder;
        }
        return null;
    }

    private void getPlayerIngredientCount(RecipeHolder<GunSmithTableRecipe> holder) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || holder == null) {
            return;
        }
        List<GunSmithTableIngredient> ingredients = ((GunSmithTableRecipe)holder.value()).getInputs();
        int size = ingredients.size();
        this.playerIngredientCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; ++i) {
            GunSmithTableIngredient ingredient = ingredients.get(i);
            Inventory inventory = player.getInventory();
            int count = 0;
            for (ItemStack stack : inventory.items) {
                if (stack.isEmpty() || !ingredient.getIngredient().test(stack)) continue;
                count += stack.getCount();
            }
            this.playerIngredientCount.put(i, count);
        }
    }

    public void updateIngredientCount() {
        if (this.selectedRecipe != null) {
            this.getPlayerIngredientCount(this.selectedRecipe);
        }
        this.init();
    }

    public void init() {
        super.init();
        if (this.filterList == null) {
            this.filterList = new GunPackList(this.minecraft, 134, this.imageHeight, this.topPos, this.topPos + this.imageHeight + 1, 15, this.recipes, this);
        }
        this.filterList.setSize(134, this.imageHeight);
        this.filterList.setPosition(this.leftPos, this.topPos);
        this.classifyRecipes();
        this.clearWidgets();
        this.addTypePageButtons();
        this.addTypeButtons();
        this.addIndexPageButtons();
        this.addIndexButtons();
        this.addRenderableWidget((GuiEventListener)new FlatColorButton(this.leftPos - 10, this.topPos, 9, 9, (Component)Component.literal((String)"F"), b -> {
            this.filterEnabled = !this.filterEnabled;
            this.init();
        }).setTooltips("gui.tacz.gun_smith_table.filter"));
        if (this.filterEnabled) {
            this.addRenderableWidget((GuiEventListener)this.filterList);
        } else {
            this.addScaleButtons();
            this.addUrlButton();
        }
        this.addCraftButton();
    }

    private void addCraftButton() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 289, this.topPos + 162, 48, 18, 138, 164, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null && this.playerIngredientCount != null) {
                List<GunSmithTableIngredient> inputs = ((GunSmithTableRecipe)this.selectedRecipe.value()).getInputs();
                int size = inputs.size();
                for (int i = 0; i < size; ++i) {
                    boolean isCreative;
                    if (i >= this.playerIngredientCount.size()) {
                        return;
                    }
                    int hasCount = this.playerIngredientCount.get(i);
                    int needCount = inputs.get(i).getCount();
                    boolean bl = isCreative = Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative();
                    if (hasCount >= needCount || isCreative) continue;
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new ClientMessageCraft(this.selectedRecipe.id(), ((GunSmithTableMenu)this.menu).containerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }));
    }

    private void addUrlButton() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 112, this.topPos + 164, 18, 18, 149, 211, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null) {
                ResourceLocation id;
                ItemStack output = ((GunSmithTableRecipe)this.selectedRecipe.value()).getOutput();
                Item item = output.getItem();
                if (item instanceof IGun) {
                    IGun iGun = (IGun)item;
                    id = iGun.getGunId(output);
                } else if (item instanceof IAttachment) {
                    IAttachment iAttachment = (IAttachment)item;
                    id = iAttachment.getAttachmentId(output);
                } else if (item instanceof IAmmo) {
                    IAmmo iAmmo = (IAmmo)item;
                    id = iAmmo.getAmmoId(output);
                } else {
                    return;
                }
                PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
                if (packInfo == null) {
                    return;
                }
                String url = packInfo.getUrl();
                if (StringUtils.isNotBlank((CharSequence)url) && this.minecraft != null) {
                    this.minecraft.setScreen((Screen)new ConfirmLinkScreen(yes -> {
                        if (yes) {
                            Util.getPlatform().openUri(url);
                        }
                        this.minecraft.setScreen((Screen)this);
                    }, url, false));
                }
            }
        }));
    }

    private void addIndexButtons() {
        int finalIndex;
        if (this.selectedRecipeList == null || this.selectedRecipeList.isEmpty()) {
            return;
        }
        for (int i = 0; i < 6 && (finalIndex = i + this.indexPage * 6) < this.selectedRecipeList.size(); ++i) {
            int yOffset = this.topPos + 66 + 17 * i;
            ResourceLocation recipeId = this.selectedRecipeList.get(finalIndex);
            RecipeHolder<GunSmithTableRecipe> holder = this.getSelectedRecipe(recipeId);
            if (holder == null) continue;
            ResultButton button = (ResultButton)this.addRenderableWidget((GuiEventListener)new ResultButton(this.leftPos + 144, yOffset, ((GunSmithTableRecipe)holder.value()).getOutput(), b -> {
                this.selectedRecipe = holder;
                this.getPlayerIngredientCount(this.selectedRecipe);
                this.init();
            }));
            if (this.selectedRecipe == null || !holder.id().equals((Object)this.selectedRecipe.id())) continue;
            button.setSelected(true);
        }
    }

    private void addTypeButtons() {
        List<TabConfig> list = Arrays.asList(this.recipeKeys.values().toArray(new TabConfig[0]));
        for (int i = 0; i < 7; ++i) {
            int typeIndex = this.typePage * 7 + i;
            if (typeIndex >= this.recipes.size()) {
                return;
            }
            TabConfig tabConfig = list.get(typeIndex);
            ResourceLocation type = tabConfig.id();
            int xOffset = this.leftPos + 157 + 24 * i;
            ItemStack icon = tabConfig.icon().apply((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            TypeButton typeButton = new TypeButton(xOffset, this.topPos + 2, icon, b -> {
                this.selectedType = type;
                this.selectedRecipeList = this.recipes.get(type);
                this.indexPage = 0;
                this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList.isEmpty() ? null : this.selectedRecipeList.get(0));
                this.getPlayerIngredientCount(this.selectedRecipe);
                this.init();
            });
            typeButton.setTooltip(Tooltip.create((Component)tabConfig.getName(), (Component)tabConfig.getName()));
            if (this.selectedType.equals((Object)type)) {
                typeButton.setSelected(true);
            }
            this.addRenderableWidget((GuiEventListener)typeButton);
        }
    }

    private void addIndexPageButtons() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 143, this.topPos + 56, 96, 6, 40, 166, 6, TEXTURE, b -> {
            if (this.indexPage > 0) {
                --this.indexPage;
                this.init();
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 143, this.topPos + 171, 96, 6, 40, 186, 6, TEXTURE, b -> {
            int maxIndexPage;
            if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty() && this.indexPage < (maxIndexPage = (this.selectedRecipeList.size() - 1) / 6)) {
                ++this.indexPage;
                this.init();
            }
        }));
    }

    private void addTypePageButtons() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 136, this.topPos + 4, 18, 20, 0, 162, 20, TEXTURE, b -> {
            if (this.typePage > 0) {
                --this.typePage;
                this.init();
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 327, this.topPos + 4, 18, 20, 20, 162, 20, TEXTURE, b -> {
            int maxIndexPage = (this.recipes.size() - 1) / 7;
            if (this.typePage < maxIndexPage) {
                ++this.typePage;
                this.init();
            }
        }));
    }

    private void addScaleButtons() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.topPos + 5, 10, 10, 188, 173, 10, TEXTURE, b -> {
            this.scale = Math.min(this.scale + 20, 200);
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 17, this.topPos + 5, 10, 10, 200, 173, 10, TEXTURE, b -> {
            this.scale = Math.max(this.scale - 20, 10);
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 29, this.topPos + 5, 10, 10, 212, 173, 10, TEXTURE, b -> {
            this.scale = 70;
        }));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pMouseX > (double)(this.leftPos + 143) && pMouseX < (double)(this.leftPos + 143 + 94) && pMouseY > (double)(this.topPos + 66) && pMouseY < (double)(this.topPos + 66 + 85)) {
            if (pScrollY > 0.0) {
                this.indexPage = Math.max(0, this.indexPage - 1);
            } else {
                int maxIndexPage = (this.selectedRecipeList.size() - 1) / 6;
                this.indexPage = Math.min(maxIndexPage, this.indexPage + 1);
            }
            this.init();
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        TabConfig config;
        super.render(graphics, mouseX, mouseY, partialTick);
        GunSmithTableScreen.drawModCenteredString(graphics, this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.preview"), this.leftPos + 108, this.topPos + 5, 0x555555);
        if (this.selectedType != null && (config = this.recipeKeys.get(this.selectedType)) != null) {
            graphics.drawString(this.font, config.getName(), this.leftPos + 150, this.topPos + 32, 0x555555, false);
        }
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.ingredient"), this.leftPos + 254, this.topPos + 50, 0x555555, false);
        GunSmithTableScreen.drawModCenteredString(graphics, this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.craft"), this.leftPos + 312, this.topPos + 167, 0xFFFFFF);
        if (!this.filterEnabled && this.selectedRecipe != null) {
            this.renderLeftModel((GunSmithTableRecipe)this.selectedRecipe.value());
            this.renderPackInfo(graphics, this.selectedRecipe);
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.count", (Object[])new Object[]{((GunSmithTableRecipe)this.selectedRecipe.value()).getResult().getResult().getCount()}), this.leftPos + 254, this.topPos + 140, 0x555555, false);
        }
        if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty()) {
            this.renderIngredient(graphics);
        }
        this.renderables.stream().filter(w -> w instanceof ResultButton).forEach(w -> ((ResultButton)((Object)w)).renderTooltips(stack -> graphics.renderTooltip(this.font, stack, mouseX, mouseY)));
    }

    private void renderPackInfo(GuiGraphics gui, RecipeHolder<GunSmithTableRecipe> holder) {
        ResourceLocation id;
        ItemStack output = ((GunSmithTableRecipe)holder.value()).getOutput();
        Item item = output.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            id = iGun.getGunId(output);
        } else if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            id = iAttachment.getAttachmentId(output);
        } else if (item instanceof IAmmo) {
            IAmmo iAmmo = (IAmmo)item;
            id = iAmmo.getAmmoId(output);
        } else {
            return;
        }
        PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
        PoseStack poseStack = gui.pose();
        if (packInfo != null) {
            poseStack.pushPose();
            poseStack.scale(0.75f, 0.75f, 1.0f);
            MutableComponent nameText = Component.translatable((String)packInfo.getName());
            gui.drawString(this.font, (Component)nameText, (int)((float)(this.leftPos + 6) / 0.75f), (int)((float)(this.topPos + 122) / 0.75f), ChatFormatting.DARK_GRAY.getColor().intValue(), false);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 1.0f);
            int offsetX = (this.leftPos + 6) * 2;
            int offsetY = (this.topPos + 123) * 2;
            int nameWidth = this.font.width((FormattedText)nameText);
            MutableComponent ver = Component.literal((String)("v" + packInfo.getVersion())).withStyle(ChatFormatting.UNDERLINE);
            gui.drawString(this.font, (Component)ver, (int)((float)offsetX + (float)nameWidth * 0.75f / 0.5f + 5.0f), offsetY, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
            offsetY += 14;
            String descKey = packInfo.getDescription();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{descKey})) {
                MutableComponent desc = Component.translatable((String)descKey);
                List split = this.font.split((FormattedText)desc, 245);
                for (FormattedCharSequence charSequence : split) {
                    gui.drawString(this.font, charSequence, offsetX, offsetY, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
                    Objects.requireNonNull(this.font);
                    offsetY += 9;
                }
                offsetY += 3;
            }
            gui.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.license").append((Component)Component.literal((String)packInfo.getLicense()).withStyle(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
            offsetY += 12;
            List<String> authors = packInfo.getAuthors();
            if (!authors.isEmpty()) {
                gui.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.authors").append((Component)Component.literal((String)StringUtils.join(authors, (String)", ")).withStyle(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
                offsetY += 12;
            }
            gui.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.date").append((Component)Component.literal((String)packInfo.getDate()).withStyle(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
            poseStack.popPose();
        } else {
            ResourceLocation recipeId = holder.id();
            gui.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.error").withStyle(ChatFormatting.DARK_RED), this.leftPos + 6, this.topPos + 122, 0xAF0000, false);
            gui.drawString(this.font, (Component)Component.translatable((String)"gui.tacz.gun_smith_table.error.id", (Object[])new Object[]{recipeId.toString()}).withStyle(ChatFormatting.DARK_RED), this.leftPos + 6, this.topPos + 134, 0xFFFFFF, false);
            PackInfo errorPackInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
            if (errorPackInfo != null) {
                gui.drawString(this.font, (Component)Component.translatable((String)errorPackInfo.getName()).withStyle(ChatFormatting.DARK_RED), this.leftPos + 6, this.topPos + 146, 0xAF0000, false);
            }
        }
    }

    private void renderIngredient(GuiGraphics gui) {
        if (this.selectedRecipe == null) {
            return;
        }
        List<GunSmithTableIngredient> inputs = ((GunSmithTableRecipe)this.selectedRecipe.value()).getInputs();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 2; ++j) {
                int index = i * 2 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int offsetX = this.leftPos + 254 + 45 * j;
                int offsetY = this.topPos + 62 + 17 * i;
                GunSmithTableIngredient smithTableIngredient = inputs.get(index);
                Ingredient ingredient = smithTableIngredient.getIngredient();
                ItemStack[] items = ingredient.getItems();
                int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
                ItemStack item = items[itemIndex];
                gui.renderFakeItem(item, offsetX, offsetY);
                PoseStack poseStack = gui.pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 200.0f);
                poseStack.scale(0.5f, 0.5f, 1.0f);
                int count = smithTableIngredient.getCount();
                if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
                    gui.drawString(this.font, String.format("%d/\u221e", count), (offsetX + 17) * 2, (offsetY + 10) * 2, 0xFFFFFF, false);
                } else {
                    int hasCount = 0;
                    if (this.playerIngredientCount != null && index < this.playerIngredientCount.size()) {
                        hasCount = this.playerIngredientCount.get(index);
                    }
                    int color = count <= hasCount ? 0xFFFFFF : 0xFF0000;
                    gui.drawString(this.font, String.format("%d/%d", count, hasCount), (offsetX + 17) * 2, (offsetY + 10) * 2, color, false);
                }
                poseStack.popPose();
            }
        }
    }

    private void renderLeftModel(GunSmithTableRecipe recipe) {
        RenderDistance.markGuiRenderTimestamp();
        float rotationPeriod = 8.0f;
        int xPos = this.leftPos + 60;
        int yPos = this.topPos + 50;
        int startX = this.leftPos + 3;
        int startY = this.topPos + 16;
        int width = 128;
        int height = 99;
        float rotPitch = 15.0f;
        Window window = Minecraft.getInstance().getWindow();
        double windowGuiScale = window.getGuiScale();
        int scissorX = (int)((double)startX * windowGuiScale);
        int scissorY = (int)((double)window.getHeight() - (double)(startY + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.translate((float)xPos, (float)yPos, 200.0f);
        posestack.translate(8.0f, 8.0f, 0.0f);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale((float)this.scale, (float)this.scale, (float)this.scale);
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.mul((Matrix4fc)Axis.XP.rotationDegrees(rotPitch).get(new Matrix4f()));
        posestack.mul((Matrix4fc)Axis.YP.rotationDegrees(rot).get(new Matrix4f()));
        RenderSystem.applyModelViewMatrix();
        PoseStack tmpPose = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Lighting.setupForFlatItems();
        Minecraft.getInstance().getItemRenderer().renderStatic(recipe.getOutput(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, tmpPose, (MultiBufferSource)bufferSource, null, 0);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableScissor();
    }

    protected void renderLabels(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTick, int mouseX, int mouseY) {
        gui.blit(SIDE, this.leftPos, this.topPos, 0, 0, 134, 187);
        gui.blit(TEXTURE, this.leftPos + 136, this.topPos + 27, 0, 0, 208, 160);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

