/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerShoot;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class LocalPlayerShoot {
    private static final Predicate<IGunOperator> SHOOT_LOCKED_CONDITION = operator -> operator.getSynShootCoolDown() > 0L;
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerShoot(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public ShootResult shoot() {
        boolean noAmmo;
        if (System.currentTimeMillis() - LocalPlayerDataHolder.clientClickButtonTimestamp < 50L) {
            return ShootResult.COOL_DOWN;
        }
        if (!this.data.isShootRecorded) {
            return ShootResult.COOL_DOWN;
        }
        if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
            this.data.isShootRecorded = true;
            return ShootResult.IS_DRAWING;
        }
        ItemStack mainHandItem = this.player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (!(item instanceof IGun)) {
            return ShootResult.NOT_GUN;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(mainHandItem).orElse(null);
        if (gunIndexOptional.isEmpty() || display == null) {
            return ShootResult.ID_NOT_EXIST;
        }
        ClientGunIndex gunIndex = gunIndexOptional.get();
        GunData gunData = gunIndex.getGunData();
        long coolDown = this.getCoolDown(iGun, mainHandItem, gunData);
        if (coolDown >= 50L) {
            return ShootResult.COOL_DOWN;
        }
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)this.player);
        if (gunOperator.getSynReloadState().getStateType().isReloading()) {
            return ShootResult.IS_RELOADING;
        }
        if (gunOperator.getSynDrawCoolDown() != 0L) {
            return ShootResult.IS_DRAWING;
        }
        if (gunOperator.getSynIsBolting()) {
            return ShootResult.IS_BOLTING;
        }
        if (gunOperator.getSynMeleeCoolDown() != 0L) {
            return ShootResult.IS_MELEE;
        }
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean useInventoryAmmo = iGun.useInventoryAmmo(mainHandItem);
        boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(mainHandItem) && boltType != Bolt.OPEN_BOLT;
        boolean hasInventoryAmmo = iGun.hasInventoryAmmo((LivingEntity)this.player, mainHandItem, gunOperator.needCheckAmmo()) || hasAmmoInBarrel;
        int ammoCount = iGun.getCurrentAmmoCount(mainHandItem) + (hasAmmoInBarrel ? 1 : 0);
        boolean bl = noAmmo = useInventoryAmmo && !hasInventoryAmmo || !useInventoryAmmo && ammoCount < 1;
        if (noAmmo) {
            SoundPlayManager.playDryFireSound((LivingEntity)this.player, display);
            return ShootResult.NO_AMMO;
        }
        if (gunData.hasHeatData() && iGun.isOverheatLocked(mainHandItem)) {
            SoundPlayManager.playDryFireSound((LivingEntity)this.player, display);
            return ShootResult.OVERHEATED;
        }
        if (boltType == Bolt.MANUAL_ACTION && !hasAmmoInBarrel) {
            IClientPlayerGunOperator.fromLocalPlayer(this.player).bolt();
            return ShootResult.NEED_BOLT;
        }
        if (gunOperator.getSynSprintTime() > 0.0f) {
            return ShootResult.IS_SPRINTING;
        }
        if (((GunShootEvent)NeoForge.EVENT_BUS.post((Event)new GunShootEvent((LivingEntity)this.player, mainHandItem, LogicalSide.CLIENT))).isCanceled()) {
            return ShootResult.FORGE_EVENT_CANCEL;
        }
        this.data.lockState(SHOOT_LOCKED_CONDITION);
        this.data.isShootRecorded = false;
        this.doShoot(display, iGun, mainHandItem, gunData, coolDown);
        return ShootResult.SUCCESS;
    }

    private void doShoot(GunDisplayInstance display, IGun iGun, ItemStack mainHandItem, GunData gunData, long delay) {
        boolean hasAmmoInBarrel;
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        Bolt boltType = gunData.getBolt();
        boolean consumeAmmo = IGunOperator.fromLivingEntity((LivingEntity)this.player).consumesAmmoOrNot();
        boolean bl = hasAmmoInBarrel = iGun.hasBulletInBarrel(mainHandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = consumeAmmo ? iGun.getCurrentAmmoCount(mainHandItem) + (hasAmmoInBarrel ? 1 : 0) : Integer.MAX_VALUE;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        int maxCount = Math.min(ammoCount, fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1);
        AtomicInteger count = new AtomicInteger(0);
        LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            if (count.get() == 0) {
                this.data.isShootRecorded = true;
            }
            if (gunData.hasHeatData() && iGun.isOverheatLocked(mainHandItem)) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() >= maxCount || this.player.isDeadOrDying()) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() == 0) {
                if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
                    return;
                }
                this.data.clientLastShootTimestamp = this.data.clientShootTimestamp;
                this.data.clientShootTimestamp = System.currentTimeMillis();
                PacketDistributor.sendToServer((CustomPacketPayload)new ClientMessagePlayerShoot(this.data.clientShootTimestamp - this.data.clientBaseTimestamp), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            Minecraft.getInstance().submitAsync(() -> {
                boolean fire;
                boolean bl = fire = !((GunFireEvent)NeoForge.EVENT_BUS.post((Event)new GunFireEvent((LivingEntity)this.player, mainHandItem, LogicalSide.CLIENT))).isCanceled();
                if (fire) {
                    LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
                    if (animationStateMachine != null) {
                        animationStateMachine.trigger("shoot");
                    }
                    boolean useSilenceSound = this.useSilenceSound();
                    SoundPlayManager.stopPlayGunSound(display, SoundManager.INSPECT_SOUND);
                    if (useSilenceSound) {
                        SoundPlayManager.playSilenceSound((LivingEntity)this.player, display, gunData);
                    } else {
                        SoundPlayManager.playShootSound((LivingEntity)this.player, display, gunData);
                    }
                }
            });
            count.getAndIncrement();
        }, delay, period, TimeUnit.MILLISECONDS);
    }

    private boolean useSilenceSound() {
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((LivingEntity)this.player).getCacheProperty();
        if (cacheProperty != null) {
            Pair silence = (Pair)cacheProperty.getCache(SilenceModifier.ID);
            return (Boolean)silence.right();
        }
        return false;
    }

    private long getCoolDown(IGun iGun, ItemStack mainHandItem, GunData gunData) {
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        long coolDown = fireMode == FireMode.BURST ? (long)(gunData.getBurstData().getMinInterval() * 1000.0) - (System.currentTimeMillis() - this.data.clientShootTimestamp) : gunData.getShootInterval((LivingEntity)this.player, fireMode, mainHandItem) - (System.currentTimeMillis() - this.data.clientShootTimestamp);
        return Math.max(coolDown, 0L);
    }

    public long getClientShootCoolDown() {
        ItemStack mainHandItem = this.player.getMainHandItem();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return -1L;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndexOptional.map(commonGunIndex -> this.getCoolDown(iGun, mainHandItem, commonGunIndex.getGunData())).orElse(-1L);
    }
}

