/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerMelee;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class LocalPlayerMelee {
    public static final String MELEE_STOCK_ANIMATION = "melee_stock";
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerMelee(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void melee() {
        if (this.data.clientStateLock) {
            return;
        }
        ItemStack mainHandItem = this.player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        GunDisplayInstance display = TimelessAPI.getGunDisplay(mainHandItem).orElse(null);
        if (display == null) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        ResourceLocation muzzleId = iGun.getAttachmentId(mainHandItem, AttachmentType.MUZZLE);
        MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
        if (muzzleMeleeData != null) {
            this.doMuzzleMelee(display);
            return;
        }
        ResourceLocation stockId = iGun.getAttachmentId(mainHandItem, AttachmentType.STOCK);
        MeleeData stockMeleeData = this.getMeleeData(stockId);
        if (stockMeleeData != null) {
            this.doStockMelee(display);
            return;
        }
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
            if (defaultMeleeData == null) {
                return;
            }
            String animationType = defaultMeleeData.getAnimationType();
            if (MELEE_STOCK_ANIMATION.equals(animationType)) {
                this.doStockMelee(display);
                return;
            }
            this.doPushMelee(display);
        });
    }

    private boolean prepareMelee() {
        this.data.lockState(operator -> operator.getSynMeleeCoolDown() > 0L);
        GunMeleeEvent gunMeleeEvent = new GunMeleeEvent((LivingEntity)this.player, this.player.getMainHandItem(), LogicalSide.CLIENT);
        return !((GunMeleeEvent)NeoForge.EVENT_BUS.post((Event)gunMeleeEvent)).isCanceled();
    }

    private void doMuzzleMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleeBayonetSound((LivingEntity)this.player, display);
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerMelee.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_muzzle");
            }
        }
    }

    private void doStockMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleeStockSound((LivingEntity)this.player, display);
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerMelee.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_stock");
            }
        }
    }

    private void doPushMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleePushSound((LivingEntity)this.player, display);
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerMelee.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_push");
            }
        }
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getClientAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

