/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.event.common.GunFireSelectEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerFireSelect;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class LocalPlayerFireSelect {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerFireSelect(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void fireSelect() {
        if (this.data.clientStateLock) {
            return;
        }
        ItemStack mainHandItem = this.player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        if (((GunFireSelectEvent)NeoForge.EVENT_BUS.post((Event)new GunFireSelectEvent((LivingEntity)this.player, this.player.getMainHandItem(), LogicalSide.CLIENT))).isCanceled()) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(gunIndex -> {
            SoundPlayManager.playFireSelectSound((LivingEntity)this.player, gunIndex);
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerFireSelect.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (iGun instanceof AbstractGunItem) {
                AbstractGunItem logicGun = (AbstractGunItem)iGun;
                logicGun.fireSelect(null, mainHandItem);
            }
            AttachmentPropertyManager.postChangeEvent((LivingEntity)this.player, mainHandItem);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("fire_select");
            }
        });
    }
}

