/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class TickAnimationEvent {
    @SubscribeEvent
    public static void tickAnimation(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(gunIndex -> {
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = gunIndex.getAnimationStateMachine();
            if (player.input == null) {
                animationStateMachine.trigger("idle");
                return;
            }
            if (!player.isMovingSlowly() && player.isSprinting()) {
                animationStateMachine.trigger("run");
            } else if (!player.isMovingSlowly() && (double)player.input.getMoveVector().length() > 0.01) {
                animationStateMachine.trigger("walk");
            } else {
                animationStateMachine.trigger("idle");
            }
        });
    }

    @SubscribeEvent
    public static void tickAnimation(RenderFrameEvent.Post event) {
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)mainHandItem.getItem()).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)blockEntityWithoutLevelRenderer;
            if (renderer.needReInit(mainHandItem)) {
                renderer.tryInit(mainHandItem, (Player)player, event.getPartialTick().getGameTimeDeltaPartialTick(false));
            }
            renderer.visualUpdate(mainHandItem);
        }
    }
}

