/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block.entity;

import com.tacz.guns.block.StatueBlock;
import com.tacz.guns.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StatueBlockEntity
extends BlockEntity {
    public static final BlockEntityType<StatueBlockEntity> TYPE = BlockEntityType.Builder.of(StatueBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.STATUE.get()}).build(null);
    private static final String ITEM_TAG = "Item";
    private ItemStack gunItem = ItemStack.EMPTY;

    public StatueBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(TYPE, pPos, pBlockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState state, StatueBlockEntity statueBlockEntity) {
        if (level.getGameTime() % 100L == 0L && !statueBlockEntity.gunItem.isEmpty()) {
            Direction direction = (Direction)state.getValue((Property)StatueBlock.FACING);
            double x = (double)blockPos.getX() + (double)direction.getStepX() * 0.75 + 0.5;
            double z = (double)blockPos.getZ() + (double)direction.getStepZ() * 0.75 + 0.5;
            double dx = -0.02 + level.random.nextDouble() * 0.04;
            double dz = -0.02 + level.random.nextDouble() * 0.04;
            double dy = -0.02 + level.random.nextDouble() * 0.04;
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, (double)blockPos.getY() + 2.25, z, dx, dy, dz);
        }
    }

    public ItemStack getGunItem() {
        return this.gunItem;
    }

    public void setGun(ItemStack stack) {
        this.dropItem();
        this.gunItem = stack.copy();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
        this.setChanged();
    }

    public void dropItem() {
        if (!this.gunItem.isEmpty() && this.level != null) {
            Direction direction = (Direction)this.getBlockState().getValue((Property)StatueBlock.FACING);
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition.relative(direction).above(), (ItemStack)this.gunItem);
            this.gunItem = ItemStack.EMPTY;
            if (this.level != null) {
                BlockState state = this.level.getBlockState(this.worldPosition);
                this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            }
            this.setChanged();
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(ITEM_TAG, 10)) {
            this.gunItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(ITEM_TAG));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(ITEM_TAG, this.gunItem.saveOptional(provider));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.put(ITEM_TAG, this.gunItem.saveOptional(provider));
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

