/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.mojang.serialization.MapCodec;
import com.tacz.guns.block.AbstractGunSmithTableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableBlockC
extends AbstractGunSmithTableBlock {
    public static final MapCodec<GunSmithTableBlockC> CODEC = GunSmithTableBlockC.simpleCodec(properties -> new GunSmithTableBlockC());
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    protected MapCodec<GunSmithTableBlockC> codec() {
        return CODEC;
    }

    public GunSmithTableBlockC() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos above = clickedPos.above();
        Level level = context.getLevel();
        if (level.getBlockState(above).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(above)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            BlockPos above = pos.above();
            world.setBlock(above, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() == Direction.Axis.Y && (half.equals((Object)DoubleBlockHalf.LOWER) && facing == Direction.UP || half.equals((Object)DoubleBlockHalf.UPPER) && facing == Direction.DOWN) && !facingState.is((Block)this)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf half;
        if (!level.isClientSide && player.isCreative() && (half = (DoubleBlockHalf)blockState.getValue(HALF)) == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, pos, blockState, player);
    }

    @Override
    public boolean isRoot(BlockState blockState) {
        return ((DoubleBlockHalf)blockState.getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER);
    }

    @Override
    public BlockPos getRootPos(BlockPos pos, BlockState blockState) {
        return ((DoubleBlockHalf)blockState.getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER) ? pos : pos.below();
    }
}

