/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.mojang.serialization.MapCodec;
import com.tacz.guns.block.AbstractGunSmithTableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableBlockB
extends AbstractGunSmithTableBlock {
    public static final MapCodec<GunSmithTableBlockB> CODEC = GunSmithTableBlockB.simpleCodec(properties -> new GunSmithTableBlockB());
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;

    protected MapCodec<GunSmithTableBlockB> codec() {
        return CODEC;
    }

    public GunSmithTableBlockB() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)BedPart.FOOT));
    }

    private static Direction getNeighbourDirection(BedPart bedPart, Direction direction) {
        return bedPart == BedPart.FOOT ? direction : direction.getOpposite();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getClockWise();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos relative = clickedPos.relative(direction);
        Level level = context.getLevel();
        if (level.getBlockState(relative).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(relative)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (!worldIn.isClientSide) {
            BlockPos relative = pos.relative((Direction)state.getValue((Property)FACING));
            worldIn.setBlock(relative, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedPart;
        if (!level.isClientSide && player.isCreative() && (bedPart = (BedPart)blockState.getValue(PART)) == BedPart.FOOT && (blockstate = level.getBlockState(blockpos = pos.relative(GunSmithTableBlockB.getNeighbourDirection(bedPart, (Direction)blockState.getValue((Property)FACING))))).is((Block)this) && blockstate.getValue(PART) == BedPart.HEAD) {
            level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, pos, blockState, player);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (direction == GunSmithTableBlockB.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return facingState.is((Block)this) && facingState.getValue(PART) != state.getValue(PART) ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, currentPos, facingPos);
    }

    @Override
    public boolean isRoot(BlockState blockState) {
        return ((BedPart)blockState.getValue(PART)).equals((Object)BedPart.FOOT);
    }

    @Override
    public float parseRotation(Direction direction) {
        return 90 - 90 * direction.get2DDataValue();
    }

    @Override
    public BlockPos getRootPos(BlockPos pos, BlockState blockState) {
        return ((BedPart)blockState.getValue(PART)).equals((Object)BedPart.FOOT) ? pos : pos.relative(GunSmithTableBlockB.getNeighbourDirection(BedPart.HEAD, (Direction)blockState.getValue((Property)FACING)));
    }
}

