/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IBlock;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface BlockItemDataAccessor
extends IBlock {
    public static final String BLOCK_ID = "BlockId";

    @Override
    @Nonnull
    default public ResourceLocation getBlockId(ItemStack block) {
        CompoundTag nbt = ((CustomData)block.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(BLOCK_ID, 8)) {
            ResourceLocation gunId = ResourceLocation.tryParse((String)nbt.getString(BLOCK_ID));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_BLOCK_ID);
        }
        return DefaultAssets.EMPTY_BLOCK_ID;
    }

    @Override
    default public void setBlockId(ItemStack block, @Nullable ResourceLocation blockId) {
        block.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (blockId != null) {
                tag.putString(BLOCK_ID, blockId.toString());
                return;
            }
            tag.putString(BLOCK_ID, DefaultAssets.EMPTY_BLOCK_ID.toString());
        }));
    }
}

