/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAttachment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface AttachmentItemDataAccessor
extends IAttachment {
    public static final String ATTACHMENT_ID_TAG = "AttachmentId";
    public static final String SKIN_ID_TAG = "Skin";
    public static final String ZOOM_NUMBER_TAG = "ZoomNumber";
    public static final String LASER_COLOR_TAG = "LaserColor";

    public static boolean isAttachmentLike(CompoundTag tag) {
        return tag.contains(ATTACHMENT_ID_TAG, 8);
    }

    @Nonnull
    public static ResourceLocation getAttachmentIdFromTag(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        if (AttachmentItemDataAccessor.isAttachmentLike(nbt)) {
            ResourceLocation attachmentId = ResourceLocation.tryParse((String)nbt.getString(ATTACHMENT_ID_TAG));
            return Objects.requireNonNullElse(attachmentId, DefaultAssets.EMPTY_ATTACHMENT_ID);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    public static int getZoomNumberFromTag(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return 0;
        }
        if (nbt.contains(ZOOM_NUMBER_TAG, 3)) {
            return nbt.getInt(ZOOM_NUMBER_TAG);
        }
        return 0;
    }

    public static void setZoomNumberToTag(CompoundTag nbt, int zoomNumber) {
        nbt.putInt(ZOOM_NUMBER_TAG, zoomNumber);
    }

    public static void setLaserColorToTag(CompoundTag nbt, int color) {
        nbt.putInt(LASER_COLOR_TAG, color);
    }

    @Override
    @Nonnull
    default public ResourceLocation getAttachmentId(ItemStack attachmentStack) {
        CompoundTag nbt = ((CustomData)attachmentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return AttachmentItemDataAccessor.getAttachmentIdFromTag(nbt);
    }

    @Override
    default public void setAttachmentId(ItemStack attachmentStack, @Nullable ResourceLocation attachmentId) {
        attachmentStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (attachmentId != null) {
                tag.putString(ATTACHMENT_ID_TAG, attachmentId.toString());
            }
        }));
    }

    @Override
    @Nullable
    default public ResourceLocation getSkinId(ItemStack attachmentStack) {
        CompoundTag nbt = ((CustomData)attachmentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(SKIN_ID_TAG, 8)) {
            return ResourceLocation.tryParse((String)nbt.getString(SKIN_ID_TAG));
        }
        return null;
    }

    @Override
    default public void setSkinId(ItemStack attachmentStack, @Nullable ResourceLocation skinId) {
        attachmentStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (skinId != null) {
                tag.putString(SKIN_ID_TAG, skinId.toString());
            } else {
                tag.remove(SKIN_ID_TAG);
            }
        }));
    }

    @Override
    default public int getZoomNumber(ItemStack attachmentStack) {
        CompoundTag nbt = ((CustomData)attachmentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return AttachmentItemDataAccessor.getZoomNumberFromTag(nbt);
    }

    @Override
    default public void setZoomNumber(ItemStack attachmentStack, int zoomNumber) {
        attachmentStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> AttachmentItemDataAccessor.setZoomNumberToTag(tag, zoomNumber)));
    }

    @Override
    default public boolean hasCustomLaserColor(ItemStack attachmentStack) {
        CompoundTag nbt = ((CustomData)attachmentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return nbt.contains(LASER_COLOR_TAG, 3);
    }

    @Override
    default public int getLaserColor(ItemStack attachmentStack) {
        CompoundTag nbt = ((CustomData)attachmentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!this.hasCustomLaserColor(attachmentStack)) {
            return 0xFF0000;
        }
        return nbt.getInt(LASER_COLOR_TAG);
    }

    @Override
    default public void setLaserColor(ItemStack attachmentStack, int color) {
        attachmentStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> AttachmentItemDataAccessor.setLaserColorToTag(tag, color)));
    }
}

