/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.attachment;

import com.google.gson.annotations.SerializedName;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum AttachmentType implements StringRepresentable
{
    SCOPE,
    MUZZLE,
    STOCK,
    GRIP,
    LASER,
    EXTENDED_MAG,
    NONE;

    public static final Codec<AttachmentType> CODEC;
    private final String serializedName;
    private static final AttachmentType[] VALUES;

    private AttachmentType() {
        String name = this.name().toLowerCase(Locale.US);
        try {
            Field field = ((Object)((Object)this)).getClass().getField(this.name());
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (serializedName != null) {
                name = serializedName.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.serializedName = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.serializedName;
    }

    public static AttachmentType fromId(int id) {
        return VALUES[id];
    }

    static {
        CODEC = StringRepresentable.fromEnum(AttachmentType::values);
        VALUES = AttachmentType.values();
    }
}

