/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SherdTooltip;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;

public class SherdTooltipComponent
implements ClientTooltipComponent {
    private final int size = ClientConfigs.Tweaks.TOOLTIP_IMAGE_SIZE.get();
    private final ResourceKey<DecoratedPotPattern> pattern;

    public SherdTooltipComponent(SherdTooltip tooltip) {
        this.pattern = tooltip.sherd();
    }

    public int getHeight() {
        return this.size + 2;
    }

    public int getWidth(Font pFont) {
        return this.size;
    }

    public void renderImage(Font pFont, int x, int y, GuiGraphics graphics) {
        Material decoratedPotMaterial = Sheets.getDecoratedPotMaterial(this.pattern);
        if (decoratedPotMaterial != null) {
            TextureAtlasSprite sprite = decoratedPotMaterial.sprite();
            SpriteContents contents = sprite.contents();
            int width = contents.width();
            int height = contents.height();
            RenderUtil.blitSpriteSection((GuiGraphics)graphics, (int)x, (int)y, (int)this.size, (int)this.size, (float)(2.0f * (1.0f / (float)width)), (float)(2.0f * (1.0f / (float)height)), (int)((int)(12.0f * (16.0f / (float)width))), (int)((int)(12.0f * (16.0f / (float)width))), (TextureAtlasSprite)sprite);
        }
    }
}

