/*
 * Decompiled with CFR 0.152.
 */
package com.imoonday.soulbound;

import com.imoonday.soulbound.Config;
import com.mojang.logging.LogUtils;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="soulbound")
public class Soulbound {
    public static final String MODID = "soulbound";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Enchantment> SOULBOUND = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"soulbound", (String)"soulbound"));
    public static boolean curios = ModList.get().isLoaded("curios");
    public static boolean travelersBackpack = ModList.get().isLoaded("travelersbackpack");

    public Soulbound(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(this::onClone);
        Soulbound.addCuriosDropListener();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    public void onClone(PlayerEvent.Clone e) {
        Soulbound.copySoulBoundItems(e.getOriginal(), e.getEntity(), e.isWasDeath());
    }

    public static void copySoulBoundItems(Player oldPlayer, Player newPlayer, boolean wasDeath) {
        Level level = newPlayer.level();
        if (wasDeath && !level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !oldPlayer.isSpectator()) {
            ItemStack backpack;
            for (int i = 0; i < oldPlayer.getInventory().getContainerSize(); ++i) {
                ItemStack oldStack = oldPlayer.getInventory().getItem(i);
                ItemStack newStack = newPlayer.getInventory().getItem(i);
                if (!Soulbound.hasSoulbound(level, oldStack) || ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) continue;
                if (Soulbound.shouldDamage(oldPlayer, oldStack)) {
                    Soulbound.damageRandomly(oldPlayer, oldStack);
                    if (Soulbound.isBroken(oldStack)) {
                        if (Config.allowBreakItem) continue;
                        if (oldStack.isEmpty()) {
                            oldStack.grow(1);
                        }
                        oldStack.setDamageValue(oldStack.getMaxDamage() - 1);
                    }
                }
                if (newStack.isEmpty()) {
                    newPlayer.getInventory().setItem(i, oldStack);
                    continue;
                }
                newPlayer.getInventory().placeItemBackInInventory(oldStack);
            }
            if (travelersBackpack && AttachmentUtils.isWearingBackpack((Player)oldPlayer) && Soulbound.hasSoulbound(level, backpack = AttachmentUtils.getWearingBackpack((Player)oldPlayer))) {
                AttachmentUtils.getAttachment((Player)newPlayer).ifPresentOrElse(iTravelersBackpack -> {
                    iTravelersBackpack.updateBackpack(backpack);
                    iTravelersBackpack.synchronise();
                }, () -> newPlayer.getInventory().placeItemBackInInventory(backpack));
            }
        }
    }

    public static void addCuriosDropListener() {
        if (curios) {
            NeoForge.EVENT_BUS.addListener(event -> {
                LivingEntity entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)entity;
                event.addOverride(stack -> {
                    if (Soulbound.hasSoulbound((Level)player.serverLevel(), stack)) {
                        if (Soulbound.shouldDamage((Player)player, stack)) {
                            Soulbound.damageRandomly((Player)player, stack);
                            if (Soulbound.isBroken(stack)) {
                                if (Config.allowBreakItem) {
                                    return false;
                                }
                                if (stack.isEmpty()) {
                                    stack.grow(1);
                                }
                                stack.setDamageValue(stack.getMaxDamage() - 1);
                            }
                        }
                        return true;
                    }
                    return false;
                }, ICurio.DropRule.ALWAYS_KEEP);
            });
        }
    }

    private static boolean isBroken(ItemStack stack) {
        return stack.getDamageValue() >= stack.getMaxDamage();
    }

    private static boolean shouldDamage(Player player, ItemStack stack) {
        return Config.maxDamagePercent != 0 && !player.isCreative() && stack.isDamageableItem();
    }

    private static void damageRandomly(Player player, ItemStack stack) {
        int maxDamage = stack.getMaxDamage();
        int damageRange = maxDamage * Config.maxDamagePercent / 100;
        if (damageRange <= 0) {
            damageRange = maxDamage;
        }
        RandomSource random = player.getRandom();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            stack.hurtAndBreak(random.nextInt(damageRange) + 1, level2, (LivingEntity)player, item -> {});
        }
    }

    public static boolean hasSoulbound(Level level, ItemStack stack) {
        Optional holder = level.registryAccess().registry(Registries.ENCHANTMENT).flatMap(registry -> registry.getHolder(SOULBOUND));
        return holder.filter(reference -> stack.getEnchantmentLevel((Holder)reference) > 0).isPresent();
    }
}

