/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.rechaos.Settings;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import ru.ac.Protocol.Data.SocketMessage;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaos.Settings.SettingsData;
import ru.ac.rechaostricks.Constants;

public class SettingsManager {
    private static final File firstRunFile = new File("config\\ChaosTricks\\disableFirstRun");
    private static final File debug = new File("config\\ChaosTricks\\debug");
    public static AtomicReference<SettingsManager> INSTANCE = new AtomicReference();
    private SettingsData data;
    private boolean isFirstRun = this.checkIfFirstRun();

    public static SettingsManager getDefault() {
        SettingsManager settingsManager = new SettingsManager();
        settingsManager.data = new SettingsData();
        return settingsManager;
    }

    public static void init(SocketMessage messagee) {
        String message = messagee.data();
        Constants.LOG.info("Initializing config...");
        SettingsManager manager = new SettingsManager();
        try {
            manager.data = Utils.fromJson(message, SettingsData.class);
            Constants.LOG.info("Config initialization successful!");
        }
        catch (Exception e) {
            manager.data = new SettingsData();
            Constants.LOG.info("Failed to initialize config,fall back to default...");
        }
    }

    public String getAffectedPlayers() {
        if (this.data != null && this.data.targetPlayers == 2) {
            return "@a";
        }
        return "@p";
    }

    public boolean getIsGriefingAllowed() {
        return this.data == null || this.data.isMobGriefing;
    }

    public boolean checkIfFirstRun() {
        return Boolean.TRUE.equals(Utils.safeRunner(this::fistRunChecker));
    }

    private boolean fistRunChecker() throws Exception {
        if (firstRunFile.exists()) {
            this.isFirstRun = false;
            return false;
        }
        firstRunFile.mkdirs();
        firstRunFile.createNewFile();
        return true;
    }

    private void resetFirstRun() {
        if (Utils.deleteFile(firstRunFile)) {
            this.isFirstRun = false;
        }
    }

    public boolean isDebug() {
        return debug.exists();
    }

    static {
        INSTANCE.set(SettingsManager.getDefault());
    }
}

